/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A list of Amazon QuickSight parameters and the list's override values.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/Parameters" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Parameters implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The parameters that have a data type of string.
     * </p>
     */
    private java.util.List<StringParameter> stringParameters;
    /**
     * <p>
     * The parameters that have a data type of integer.
     * </p>
     */
    private java.util.List<IntegerParameter> integerParameters;
    /**
     * <p>
     * The parameters that have a data type of decimal.
     * </p>
     */
    private java.util.List<DecimalParameter> decimalParameters;
    /**
     * <p>
     * The parameters that have a data type of date-time.
     * </p>
     */
    private java.util.List<DateTimeParameter> dateTimeParameters;

    /**
     * <p>
     * The parameters that have a data type of string.
     * </p>
     * 
     * @return The parameters that have a data type of string.
     */

    public java.util.List<StringParameter> getStringParameters() {
        return stringParameters;
    }

    /**
     * <p>
     * The parameters that have a data type of string.
     * </p>
     * 
     * @param stringParameters
     *        The parameters that have a data type of string.
     */

    public void setStringParameters(java.util.Collection<StringParameter> stringParameters) {
        if (stringParameters == null) {
            this.stringParameters = null;
            return;
        }

        this.stringParameters = new java.util.ArrayList<StringParameter>(stringParameters);
    }

    /**
     * <p>
     * The parameters that have a data type of string.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setStringParameters(java.util.Collection)} or {@link #withStringParameters(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param stringParameters
     *        The parameters that have a data type of string.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Parameters withStringParameters(StringParameter... stringParameters) {
        if (this.stringParameters == null) {
            setStringParameters(new java.util.ArrayList<StringParameter>(stringParameters.length));
        }
        for (StringParameter ele : stringParameters) {
            this.stringParameters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The parameters that have a data type of string.
     * </p>
     * 
     * @param stringParameters
     *        The parameters that have a data type of string.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Parameters withStringParameters(java.util.Collection<StringParameter> stringParameters) {
        setStringParameters(stringParameters);
        return this;
    }

    /**
     * <p>
     * The parameters that have a data type of integer.
     * </p>
     * 
     * @return The parameters that have a data type of integer.
     */

    public java.util.List<IntegerParameter> getIntegerParameters() {
        return integerParameters;
    }

    /**
     * <p>
     * The parameters that have a data type of integer.
     * </p>
     * 
     * @param integerParameters
     *        The parameters that have a data type of integer.
     */

    public void setIntegerParameters(java.util.Collection<IntegerParameter> integerParameters) {
        if (integerParameters == null) {
            this.integerParameters = null;
            return;
        }

        this.integerParameters = new java.util.ArrayList<IntegerParameter>(integerParameters);
    }

    /**
     * <p>
     * The parameters that have a data type of integer.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIntegerParameters(java.util.Collection)} or {@link #withIntegerParameters(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param integerParameters
     *        The parameters that have a data type of integer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Parameters withIntegerParameters(IntegerParameter... integerParameters) {
        if (this.integerParameters == null) {
            setIntegerParameters(new java.util.ArrayList<IntegerParameter>(integerParameters.length));
        }
        for (IntegerParameter ele : integerParameters) {
            this.integerParameters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The parameters that have a data type of integer.
     * </p>
     * 
     * @param integerParameters
     *        The parameters that have a data type of integer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Parameters withIntegerParameters(java.util.Collection<IntegerParameter> integerParameters) {
        setIntegerParameters(integerParameters);
        return this;
    }

    /**
     * <p>
     * The parameters that have a data type of decimal.
     * </p>
     * 
     * @return The parameters that have a data type of decimal.
     */

    public java.util.List<DecimalParameter> getDecimalParameters() {
        return decimalParameters;
    }

    /**
     * <p>
     * The parameters that have a data type of decimal.
     * </p>
     * 
     * @param decimalParameters
     *        The parameters that have a data type of decimal.
     */

    public void setDecimalParameters(java.util.Collection<DecimalParameter> decimalParameters) {
        if (decimalParameters == null) {
            this.decimalParameters = null;
            return;
        }

        this.decimalParameters = new java.util.ArrayList<DecimalParameter>(decimalParameters);
    }

    /**
     * <p>
     * The parameters that have a data type of decimal.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDecimalParameters(java.util.Collection)} or {@link #withDecimalParameters(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param decimalParameters
     *        The parameters that have a data type of decimal.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Parameters withDecimalParameters(DecimalParameter... decimalParameters) {
        if (this.decimalParameters == null) {
            setDecimalParameters(new java.util.ArrayList<DecimalParameter>(decimalParameters.length));
        }
        for (DecimalParameter ele : decimalParameters) {
            this.decimalParameters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The parameters that have a data type of decimal.
     * </p>
     * 
     * @param decimalParameters
     *        The parameters that have a data type of decimal.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Parameters withDecimalParameters(java.util.Collection<DecimalParameter> decimalParameters) {
        setDecimalParameters(decimalParameters);
        return this;
    }

    /**
     * <p>
     * The parameters that have a data type of date-time.
     * </p>
     * 
     * @return The parameters that have a data type of date-time.
     */

    public java.util.List<DateTimeParameter> getDateTimeParameters() {
        return dateTimeParameters;
    }

    /**
     * <p>
     * The parameters that have a data type of date-time.
     * </p>
     * 
     * @param dateTimeParameters
     *        The parameters that have a data type of date-time.
     */

    public void setDateTimeParameters(java.util.Collection<DateTimeParameter> dateTimeParameters) {
        if (dateTimeParameters == null) {
            this.dateTimeParameters = null;
            return;
        }

        this.dateTimeParameters = new java.util.ArrayList<DateTimeParameter>(dateTimeParameters);
    }

    /**
     * <p>
     * The parameters that have a data type of date-time.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDateTimeParameters(java.util.Collection)} or {@link #withDateTimeParameters(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param dateTimeParameters
     *        The parameters that have a data type of date-time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Parameters withDateTimeParameters(DateTimeParameter... dateTimeParameters) {
        if (this.dateTimeParameters == null) {
            setDateTimeParameters(new java.util.ArrayList<DateTimeParameter>(dateTimeParameters.length));
        }
        for (DateTimeParameter ele : dateTimeParameters) {
            this.dateTimeParameters.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The parameters that have a data type of date-time.
     * </p>
     * 
     * @param dateTimeParameters
     *        The parameters that have a data type of date-time.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Parameters withDateTimeParameters(java.util.Collection<DateTimeParameter> dateTimeParameters) {
        setDateTimeParameters(dateTimeParameters);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStringParameters() != null)
            sb.append("StringParameters: ").append(getStringParameters()).append(",");
        if (getIntegerParameters() != null)
            sb.append("IntegerParameters: ").append(getIntegerParameters()).append(",");
        if (getDecimalParameters() != null)
            sb.append("DecimalParameters: ").append(getDecimalParameters()).append(",");
        if (getDateTimeParameters() != null)
            sb.append("DateTimeParameters: ").append(getDateTimeParameters());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Parameters == false)
            return false;
        Parameters other = (Parameters) obj;
        if (other.getStringParameters() == null ^ this.getStringParameters() == null)
            return false;
        if (other.getStringParameters() != null && other.getStringParameters().equals(this.getStringParameters()) == false)
            return false;
        if (other.getIntegerParameters() == null ^ this.getIntegerParameters() == null)
            return false;
        if (other.getIntegerParameters() != null && other.getIntegerParameters().equals(this.getIntegerParameters()) == false)
            return false;
        if (other.getDecimalParameters() == null ^ this.getDecimalParameters() == null)
            return false;
        if (other.getDecimalParameters() != null && other.getDecimalParameters().equals(this.getDecimalParameters()) == false)
            return false;
        if (other.getDateTimeParameters() == null ^ this.getDateTimeParameters() == null)
            return false;
        if (other.getDateTimeParameters() != null && other.getDateTimeParameters().equals(this.getDateTimeParameters()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStringParameters() == null) ? 0 : getStringParameters().hashCode());
        hashCode = prime * hashCode + ((getIntegerParameters() == null) ? 0 : getIntegerParameters().hashCode());
        hashCode = prime * hashCode + ((getDecimalParameters() == null) ? 0 : getDecimalParameters().hashCode());
        hashCode = prime * hashCode + ((getDateTimeParameters() == null) ? 0 : getDateTimeParameters().hashCode());
        return hashCode;
    }

    @Override
    public Parameters clone() {
        try {
            return (Parameters) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.ParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
