/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.CredentialPair;
import java.util.List;

@SdkInternalApi
public class CredentialPairMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").build();
    private static final MarshallingInfo<List> ALTERNATEDATASOURCEPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlternateDataSourceParameters").build();
    private static final CredentialPairMarshaller instance = new CredentialPairMarshaller();

    public static CredentialPairMarshaller getInstance() {
        return instance;
    }

    public void marshall(CredentialPair credentialPair, ProtocolMarshaller protocolMarshaller) {
        if (credentialPair == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)credentialPair.getUsername(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)credentialPair.getPassword(), PASSWORD_BINDING);
            protocolMarshaller.marshall(credentialPair.getAlternateDataSourceParameters(), ALTERNATEDATASOURCEPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

