/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.quicksight.model.DataSourceCredentials;
import com.amazonaws.services.quicksight.model.DataSourceParameters;
import com.amazonaws.services.quicksight.model.DataSourceType;
import com.amazonaws.services.quicksight.model.ResourcePermission;
import com.amazonaws.services.quicksight.model.SslProperties;
import com.amazonaws.services.quicksight.model.Tag;
import com.amazonaws.services.quicksight.model.VpcConnectionProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDataSourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String awsAccountId;
    private String dataSourceId;
    private String name;
    private String type;
    private DataSourceParameters dataSourceParameters;
    private DataSourceCredentials credentials;
    private List<ResourcePermission> permissions;
    private VpcConnectionProperties vpcConnectionProperties;
    private SslProperties sslProperties;
    private List<Tag> tags;
    private List<String> folderArns;

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public CreateDataSourceRequest withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public CreateDataSourceRequest withDataSourceId(String dataSourceId) {
        this.setDataSourceId(dataSourceId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateDataSourceRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateDataSourceRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateDataSourceRequest withType(DataSourceType type) {
        this.type = type.toString();
        return this;
    }

    public void setDataSourceParameters(DataSourceParameters dataSourceParameters) {
        this.dataSourceParameters = dataSourceParameters;
    }

    public DataSourceParameters getDataSourceParameters() {
        return this.dataSourceParameters;
    }

    public CreateDataSourceRequest withDataSourceParameters(DataSourceParameters dataSourceParameters) {
        this.setDataSourceParameters(dataSourceParameters);
        return this;
    }

    public void setCredentials(DataSourceCredentials credentials) {
        this.credentials = credentials;
    }

    public DataSourceCredentials getCredentials() {
        return this.credentials;
    }

    public CreateDataSourceRequest withCredentials(DataSourceCredentials credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public List<ResourcePermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<ResourcePermission> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<ResourcePermission>(permissions);
    }

    public CreateDataSourceRequest withPermissions(ResourcePermission ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<ResourcePermission>(permissions.length));
        }
        for (ResourcePermission ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public CreateDataSourceRequest withPermissions(Collection<ResourcePermission> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public void setVpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
        this.vpcConnectionProperties = vpcConnectionProperties;
    }

    public VpcConnectionProperties getVpcConnectionProperties() {
        return this.vpcConnectionProperties;
    }

    public CreateDataSourceRequest withVpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
        this.setVpcConnectionProperties(vpcConnectionProperties);
        return this;
    }

    public void setSslProperties(SslProperties sslProperties) {
        this.sslProperties = sslProperties;
    }

    public SslProperties getSslProperties() {
        return this.sslProperties;
    }

    public CreateDataSourceRequest withSslProperties(SslProperties sslProperties) {
        this.setSslProperties(sslProperties);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateDataSourceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateDataSourceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<String> getFolderArns() {
        return this.folderArns;
    }

    public void setFolderArns(Collection<String> folderArns) {
        if (folderArns == null) {
            this.folderArns = null;
            return;
        }
        this.folderArns = new ArrayList<String>(folderArns);
    }

    public CreateDataSourceRequest withFolderArns(String ... folderArns) {
        if (this.folderArns == null) {
            this.setFolderArns(new ArrayList<String>(folderArns.length));
        }
        for (String ele : folderArns) {
            this.folderArns.add(ele);
        }
        return this;
    }

    public CreateDataSourceRequest withFolderArns(Collection<String> folderArns) {
        this.setFolderArns(folderArns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getDataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.getDataSourceId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getDataSourceParameters() != null) {
            sb.append("DataSourceParameters: ").append(this.getDataSourceParameters()).append(",");
        }
        if (this.getCredentials() != null) {
            sb.append("Credentials: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getVpcConnectionProperties() != null) {
            sb.append("VpcConnectionProperties: ").append(this.getVpcConnectionProperties()).append(",");
        }
        if (this.getSslProperties() != null) {
            sb.append("SslProperties: ").append(this.getSslProperties()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getFolderArns() != null) {
            sb.append("FolderArns: ").append(this.getFolderArns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest)obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getDataSourceId() == null ^ this.getDataSourceId() == null) {
            return false;
        }
        if (other.getDataSourceId() != null && !other.getDataSourceId().equals(this.getDataSourceId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDataSourceParameters() == null ^ this.getDataSourceParameters() == null) {
            return false;
        }
        if (other.getDataSourceParameters() != null && !other.getDataSourceParameters().equals(this.getDataSourceParameters())) {
            return false;
        }
        if (other.getCredentials() == null ^ this.getCredentials() == null) {
            return false;
        }
        if (other.getCredentials() != null && !other.getCredentials().equals(this.getCredentials())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getVpcConnectionProperties() == null ^ this.getVpcConnectionProperties() == null) {
            return false;
        }
        if (other.getVpcConnectionProperties() != null && !other.getVpcConnectionProperties().equals(this.getVpcConnectionProperties())) {
            return false;
        }
        if (other.getSslProperties() == null ^ this.getSslProperties() == null) {
            return false;
        }
        if (other.getSslProperties() != null && !other.getSslProperties().equals(this.getSslProperties())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getFolderArns() == null ^ this.getFolderArns() == null) {
            return false;
        }
        return other.getFolderArns() == null || other.getFolderArns().equals(this.getFolderArns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getDataSourceId() == null ? 0 : this.getDataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDataSourceParameters() == null ? 0 : this.getDataSourceParameters().hashCode());
        hashCode = 31 * hashCode + (this.getCredentials() == null ? 0 : this.getCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConnectionProperties() == null ? 0 : this.getVpcConnectionProperties().hashCode());
        hashCode = 31 * hashCode + (this.getSslProperties() == null ? 0 : this.getSslProperties().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getFolderArns() == null ? 0 : this.getFolderArns().hashCode());
        return hashCode;
    }

    public CreateDataSourceRequest clone() {
        return (CreateDataSourceRequest)super.clone();
    }
}

