/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.SectionBasedLayoutConfiguration;
import java.util.List;

@SdkInternalApi
public class SectionBasedLayoutConfigurationMarshaller {
    private static final MarshallingInfo<List> HEADERSECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HeaderSections").build();
    private static final MarshallingInfo<List> BODYSECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BodySections").build();
    private static final MarshallingInfo<List> FOOTERSECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FooterSections").build();
    private static final MarshallingInfo<StructuredPojo> CANVASSIZEOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CanvasSizeOptions").build();
    private static final SectionBasedLayoutConfigurationMarshaller instance = new SectionBasedLayoutConfigurationMarshaller();

    public static SectionBasedLayoutConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SectionBasedLayoutConfiguration sectionBasedLayoutConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (sectionBasedLayoutConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sectionBasedLayoutConfiguration.getHeaderSections(), HEADERSECTIONS_BINDING);
            protocolMarshaller.marshall(sectionBasedLayoutConfiguration.getBodySections(), BODYSECTIONS_BINDING);
            protocolMarshaller.marshall(sectionBasedLayoutConfiguration.getFooterSections(), FOOTERSECTIONS_BINDING);
            protocolMarshaller.marshall((Object)sectionBasedLayoutConfiguration.getCanvasSizeOptions(), CANVASSIZEOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

