/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.CustomContentConfiguration;

@SdkInternalApi
public class CustomContentConfigurationMarshaller {
    private static final MarshallingInfo<String> CONTENTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentUrl").build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentType").build();
    private static final MarshallingInfo<String> IMAGESCALING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageScaling").build();
    private static final CustomContentConfigurationMarshaller instance = new CustomContentConfigurationMarshaller();

    public static CustomContentConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(CustomContentConfiguration customContentConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (customContentConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)customContentConfiguration.getContentUrl(), CONTENTURL_BINDING);
            protocolMarshaller.marshall((Object)customContentConfiguration.getContentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)customContentConfiguration.getImageScaling(), IMAGESCALING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

