/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.SnapshotFile;
import java.util.List;

@SdkInternalApi
public class SnapshotFileMarshaller {
    private static final MarshallingInfo<List> SHEETSELECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SheetSelections").build();
    private static final MarshallingInfo<String> FORMATTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FormatType").build();
    private static final SnapshotFileMarshaller instance = new SnapshotFileMarshaller();

    public static SnapshotFileMarshaller getInstance() {
        return instance;
    }

    public void marshall(SnapshotFile snapshotFile, ProtocolMarshaller protocolMarshaller) {
        if (snapshotFile == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(snapshotFile.getSheetSelections(), SHEETSELECTIONS_BINDING);
            protocolMarshaller.marshall((Object)snapshotFile.getFormatType(), FORMATTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

