/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.FieldSortOptions;
import com.amazonaws.services.quicksight.model.PaginationConfiguration;
import com.amazonaws.services.quicksight.model.transform.BoxPlotSortConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BoxPlotSortConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<FieldSortOptions> categorySort;
    private PaginationConfiguration paginationConfiguration;

    public List<FieldSortOptions> getCategorySort() {
        return this.categorySort;
    }

    public void setCategorySort(Collection<FieldSortOptions> categorySort) {
        if (categorySort == null) {
            this.categorySort = null;
            return;
        }
        this.categorySort = new ArrayList<FieldSortOptions>(categorySort);
    }

    public BoxPlotSortConfiguration withCategorySort(FieldSortOptions ... categorySort) {
        if (this.categorySort == null) {
            this.setCategorySort(new ArrayList<FieldSortOptions>(categorySort.length));
        }
        for (FieldSortOptions ele : categorySort) {
            this.categorySort.add(ele);
        }
        return this;
    }

    public BoxPlotSortConfiguration withCategorySort(Collection<FieldSortOptions> categorySort) {
        this.setCategorySort(categorySort);
        return this;
    }

    public void setPaginationConfiguration(PaginationConfiguration paginationConfiguration) {
        this.paginationConfiguration = paginationConfiguration;
    }

    public PaginationConfiguration getPaginationConfiguration() {
        return this.paginationConfiguration;
    }

    public BoxPlotSortConfiguration withPaginationConfiguration(PaginationConfiguration paginationConfiguration) {
        this.setPaginationConfiguration(paginationConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategorySort() != null) {
            sb.append("CategorySort: ").append(this.getCategorySort()).append(",");
        }
        if (this.getPaginationConfiguration() != null) {
            sb.append("PaginationConfiguration: ").append(this.getPaginationConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxPlotSortConfiguration)) {
            return false;
        }
        BoxPlotSortConfiguration other = (BoxPlotSortConfiguration)obj;
        if (other.getCategorySort() == null ^ this.getCategorySort() == null) {
            return false;
        }
        if (other.getCategorySort() != null && !other.getCategorySort().equals(this.getCategorySort())) {
            return false;
        }
        if (other.getPaginationConfiguration() == null ^ this.getPaginationConfiguration() == null) {
            return false;
        }
        return other.getPaginationConfiguration() == null || other.getPaginationConfiguration().equals(this.getPaginationConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategorySort() == null ? 0 : this.getCategorySort().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationConfiguration() == null ? 0 : this.getPaginationConfiguration().hashCode());
        return hashCode;
    }

    public BoxPlotSortConfiguration clone() {
        try {
            return (BoxPlotSortConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BoxPlotSortConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

