/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.CascadingControlSource;
import com.amazonaws.services.quicksight.model.transform.CascadingControlConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CascadingControlConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<CascadingControlSource> sourceControls;

    public List<CascadingControlSource> getSourceControls() {
        return this.sourceControls;
    }

    public void setSourceControls(Collection<CascadingControlSource> sourceControls) {
        if (sourceControls == null) {
            this.sourceControls = null;
            return;
        }
        this.sourceControls = new ArrayList<CascadingControlSource>(sourceControls);
    }

    public CascadingControlConfiguration withSourceControls(CascadingControlSource ... sourceControls) {
        if (this.sourceControls == null) {
            this.setSourceControls(new ArrayList<CascadingControlSource>(sourceControls.length));
        }
        for (CascadingControlSource ele : sourceControls) {
            this.sourceControls.add(ele);
        }
        return this;
    }

    public CascadingControlConfiguration withSourceControls(Collection<CascadingControlSource> sourceControls) {
        this.setSourceControls(sourceControls);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceControls() != null) {
            sb.append("SourceControls: ").append(this.getSourceControls());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CascadingControlConfiguration)) {
            return false;
        }
        CascadingControlConfiguration other = (CascadingControlConfiguration)obj;
        if (other.getSourceControls() == null ^ this.getSourceControls() == null) {
            return false;
        }
        return other.getSourceControls() == null || other.getSourceControls().equals(this.getSourceControls());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceControls() == null ? 0 : this.getSourceControls().hashCode());
        return hashCode;
    }

    public CascadingControlConfiguration clone() {
        try {
            return (CascadingControlConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CascadingControlConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

