/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.TableVisual;
import java.util.List;

@SdkInternalApi
public class TableVisualMarshaller {
    private static final MarshallingInfo<String> VISUALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisualId").build();
    private static final MarshallingInfo<StructuredPojo> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<StructuredPojo> SUBTITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subtitle").build();
    private static final MarshallingInfo<StructuredPojo> CHARTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChartConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> CONDITIONALFORMATTING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionalFormatting").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Actions").build();
    private static final TableVisualMarshaller instance = new TableVisualMarshaller();

    public static TableVisualMarshaller getInstance() {
        return instance;
    }

    public void marshall(TableVisual tableVisual, ProtocolMarshaller protocolMarshaller) {
        if (tableVisual == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tableVisual.getVisualId(), VISUALID_BINDING);
            protocolMarshaller.marshall((Object)tableVisual.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)tableVisual.getSubtitle(), SUBTITLE_BINDING);
            protocolMarshaller.marshall((Object)tableVisual.getChartConfiguration(), CHARTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)tableVisual.getConditionalFormatting(), CONDITIONALFORMATTING_BINDING);
            protocolMarshaller.marshall(tableVisual.getActions(), ACTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

