/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataSourceErrorInfo;
import com.amazonaws.services.quicksight.model.DataSourceParameters;
import com.amazonaws.services.quicksight.model.DataSourceType;
import com.amazonaws.services.quicksight.model.ResourceStatus;
import com.amazonaws.services.quicksight.model.SslProperties;
import com.amazonaws.services.quicksight.model.VpcConnectionProperties;
import com.amazonaws.services.quicksight.model.transform.DataSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DataSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String dataSourceId;
    private String name;
    private String type;
    private String status;
    private Date createdTime;
    private Date lastUpdatedTime;
    private DataSourceParameters dataSourceParameters;
    private List<DataSourceParameters> alternateDataSourceParameters;
    private VpcConnectionProperties vpcConnectionProperties;
    private SslProperties sslProperties;
    private DataSourceErrorInfo errorInfo;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DataSource withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public DataSource withDataSourceId(String dataSourceId) {
        this.setDataSourceId(dataSourceId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DataSource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DataSource withType(String type) {
        this.setType(type);
        return this;
    }

    public DataSource withType(DataSourceType type) {
        this.type = type.toString();
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DataSource withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public DataSource withStatus(ResourceStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public DataSource withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public DataSource withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public void setDataSourceParameters(DataSourceParameters dataSourceParameters) {
        this.dataSourceParameters = dataSourceParameters;
    }

    public DataSourceParameters getDataSourceParameters() {
        return this.dataSourceParameters;
    }

    public DataSource withDataSourceParameters(DataSourceParameters dataSourceParameters) {
        this.setDataSourceParameters(dataSourceParameters);
        return this;
    }

    public List<DataSourceParameters> getAlternateDataSourceParameters() {
        return this.alternateDataSourceParameters;
    }

    public void setAlternateDataSourceParameters(Collection<DataSourceParameters> alternateDataSourceParameters) {
        if (alternateDataSourceParameters == null) {
            this.alternateDataSourceParameters = null;
            return;
        }
        this.alternateDataSourceParameters = new ArrayList<DataSourceParameters>(alternateDataSourceParameters);
    }

    public DataSource withAlternateDataSourceParameters(DataSourceParameters ... alternateDataSourceParameters) {
        if (this.alternateDataSourceParameters == null) {
            this.setAlternateDataSourceParameters(new ArrayList<DataSourceParameters>(alternateDataSourceParameters.length));
        }
        for (DataSourceParameters ele : alternateDataSourceParameters) {
            this.alternateDataSourceParameters.add(ele);
        }
        return this;
    }

    public DataSource withAlternateDataSourceParameters(Collection<DataSourceParameters> alternateDataSourceParameters) {
        this.setAlternateDataSourceParameters(alternateDataSourceParameters);
        return this;
    }

    public void setVpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
        this.vpcConnectionProperties = vpcConnectionProperties;
    }

    public VpcConnectionProperties getVpcConnectionProperties() {
        return this.vpcConnectionProperties;
    }

    public DataSource withVpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
        this.setVpcConnectionProperties(vpcConnectionProperties);
        return this;
    }

    public void setSslProperties(SslProperties sslProperties) {
        this.sslProperties = sslProperties;
    }

    public SslProperties getSslProperties() {
        return this.sslProperties;
    }

    public DataSource withSslProperties(SslProperties sslProperties) {
        this.setSslProperties(sslProperties);
        return this;
    }

    public void setErrorInfo(DataSourceErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public DataSourceErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public DataSource withErrorInfo(DataSourceErrorInfo errorInfo) {
        this.setErrorInfo(errorInfo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.getDataSourceId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getDataSourceParameters() != null) {
            sb.append("DataSourceParameters: ").append(this.getDataSourceParameters()).append(",");
        }
        if (this.getAlternateDataSourceParameters() != null) {
            sb.append("AlternateDataSourceParameters: ").append(this.getAlternateDataSourceParameters()).append(",");
        }
        if (this.getVpcConnectionProperties() != null) {
            sb.append("VpcConnectionProperties: ").append(this.getVpcConnectionProperties()).append(",");
        }
        if (this.getSslProperties() != null) {
            sb.append("SslProperties: ").append(this.getSslProperties()).append(",");
        }
        if (this.getErrorInfo() != null) {
            sb.append("ErrorInfo: ").append(this.getErrorInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDataSourceId() == null ^ this.getDataSourceId() == null) {
            return false;
        }
        if (other.getDataSourceId() != null && !other.getDataSourceId().equals(this.getDataSourceId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getDataSourceParameters() == null ^ this.getDataSourceParameters() == null) {
            return false;
        }
        if (other.getDataSourceParameters() != null && !other.getDataSourceParameters().equals(this.getDataSourceParameters())) {
            return false;
        }
        if (other.getAlternateDataSourceParameters() == null ^ this.getAlternateDataSourceParameters() == null) {
            return false;
        }
        if (other.getAlternateDataSourceParameters() != null && !other.getAlternateDataSourceParameters().equals(this.getAlternateDataSourceParameters())) {
            return false;
        }
        if (other.getVpcConnectionProperties() == null ^ this.getVpcConnectionProperties() == null) {
            return false;
        }
        if (other.getVpcConnectionProperties() != null && !other.getVpcConnectionProperties().equals(this.getVpcConnectionProperties())) {
            return false;
        }
        if (other.getSslProperties() == null ^ this.getSslProperties() == null) {
            return false;
        }
        if (other.getSslProperties() != null && !other.getSslProperties().equals(this.getSslProperties())) {
            return false;
        }
        if (other.getErrorInfo() == null ^ this.getErrorInfo() == null) {
            return false;
        }
        return other.getErrorInfo() == null || other.getErrorInfo().equals(this.getErrorInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDataSourceId() == null ? 0 : this.getDataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getDataSourceParameters() == null ? 0 : this.getDataSourceParameters().hashCode());
        hashCode = 31 * hashCode + (this.getAlternateDataSourceParameters() == null ? 0 : this.getAlternateDataSourceParameters().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConnectionProperties() == null ? 0 : this.getVpcConnectionProperties().hashCode());
        hashCode = 31 * hashCode + (this.getSslProperties() == null ? 0 : this.getSslProperties().hashCode());
        hashCode = 31 * hashCode + (this.getErrorInfo() == null ? 0 : this.getErrorInfo().hashCode());
        return hashCode;
    }

    public DataSource clone() {
        try {
            return (DataSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

