/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DashboardError;
import com.amazonaws.services.quicksight.model.ResourceStatus;
import com.amazonaws.services.quicksight.model.transform.DashboardVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DashboardVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private Date createdTime;
    private List<DashboardError> errors;
    private Long versionNumber;
    private String status;
    private String arn;
    private String sourceEntityArn;
    private String description;

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public DashboardVersion withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public List<DashboardError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<DashboardError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<DashboardError>(errors);
    }

    public DashboardVersion withErrors(DashboardError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<DashboardError>(errors.length));
        }
        for (DashboardError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public DashboardVersion withErrors(Collection<DashboardError> errors) {
        this.setErrors(errors);
        return this;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public DashboardVersion withVersionNumber(Long versionNumber) {
        this.setVersionNumber(versionNumber);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DashboardVersion withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public DashboardVersion withStatus(ResourceStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DashboardVersion withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setSourceEntityArn(String sourceEntityArn) {
        this.sourceEntityArn = sourceEntityArn;
    }

    public String getSourceEntityArn() {
        return this.sourceEntityArn;
    }

    public DashboardVersion withSourceEntityArn(String sourceEntityArn) {
        this.setSourceEntityArn(sourceEntityArn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DashboardVersion withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors()).append(",");
        }
        if (this.getVersionNumber() != null) {
            sb.append("VersionNumber: ").append(this.getVersionNumber()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getSourceEntityArn() != null) {
            sb.append("SourceEntityArn: ").append(this.getSourceEntityArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVersion)) {
            return false;
        }
        DashboardVersion other = (DashboardVersion)obj;
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        if (other.getErrors() != null && !other.getErrors().equals(this.getErrors())) {
            return false;
        }
        if (other.getVersionNumber() == null ^ this.getVersionNumber() == null) {
            return false;
        }
        if (other.getVersionNumber() != null && !other.getVersionNumber().equals(this.getVersionNumber())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getSourceEntityArn() == null ^ this.getSourceEntityArn() == null) {
            return false;
        }
        if (other.getSourceEntityArn() != null && !other.getSourceEntityArn().equals(this.getSourceEntityArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        hashCode = 31 * hashCode + (this.getVersionNumber() == null ? 0 : this.getVersionNumber().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getSourceEntityArn() == null ? 0 : this.getSourceEntityArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public DashboardVersion clone() {
        try {
            return (DashboardVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DashboardVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

