/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.quicksight.AmazonQuickSightAsync;
import com.amazonaws.services.quicksight.AmazonQuickSightAsyncClientBuilder;
import com.amazonaws.services.quicksight.AmazonQuickSightClient;
import com.amazonaws.services.quicksight.model.CreateGroupMembershipRequest;
import com.amazonaws.services.quicksight.model.CreateGroupMembershipResult;
import com.amazonaws.services.quicksight.model.CreateGroupRequest;
import com.amazonaws.services.quicksight.model.CreateGroupResult;
import com.amazonaws.services.quicksight.model.DeleteGroupMembershipRequest;
import com.amazonaws.services.quicksight.model.DeleteGroupMembershipResult;
import com.amazonaws.services.quicksight.model.DeleteGroupRequest;
import com.amazonaws.services.quicksight.model.DeleteGroupResult;
import com.amazonaws.services.quicksight.model.DeleteUserRequest;
import com.amazonaws.services.quicksight.model.DeleteUserResult;
import com.amazonaws.services.quicksight.model.DescribeGroupRequest;
import com.amazonaws.services.quicksight.model.DescribeGroupResult;
import com.amazonaws.services.quicksight.model.DescribeUserRequest;
import com.amazonaws.services.quicksight.model.DescribeUserResult;
import com.amazonaws.services.quicksight.model.GetDashboardEmbedUrlRequest;
import com.amazonaws.services.quicksight.model.GetDashboardEmbedUrlResult;
import com.amazonaws.services.quicksight.model.ListGroupMembershipsRequest;
import com.amazonaws.services.quicksight.model.ListGroupMembershipsResult;
import com.amazonaws.services.quicksight.model.ListGroupsRequest;
import com.amazonaws.services.quicksight.model.ListGroupsResult;
import com.amazonaws.services.quicksight.model.ListUserGroupsRequest;
import com.amazonaws.services.quicksight.model.ListUserGroupsResult;
import com.amazonaws.services.quicksight.model.ListUsersRequest;
import com.amazonaws.services.quicksight.model.ListUsersResult;
import com.amazonaws.services.quicksight.model.RegisterUserRequest;
import com.amazonaws.services.quicksight.model.RegisterUserResult;
import com.amazonaws.services.quicksight.model.UpdateGroupRequest;
import com.amazonaws.services.quicksight.model.UpdateGroupResult;
import com.amazonaws.services.quicksight.model.UpdateUserRequest;
import com.amazonaws.services.quicksight.model.UpdateUserResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonQuickSightAsyncClient
extends AmazonQuickSightClient
implements AmazonQuickSightAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonQuickSightAsyncClientBuilder asyncBuilder() {
        return AmazonQuickSightAsyncClientBuilder.standard();
    }

    AmazonQuickSightAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request) {
        return this.createGroupAsync(request, null);
    }

    @Override
    public Future<CreateGroupResult> createGroupAsync(CreateGroupRequest request, final AsyncHandler<CreateGroupRequest, CreateGroupResult> asyncHandler) {
        final CreateGroupRequest finalRequest = (CreateGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGroupResult>(){

            @Override
            public CreateGroupResult call() throws Exception {
                CreateGroupResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeCreateGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGroupMembershipResult> createGroupMembershipAsync(CreateGroupMembershipRequest request) {
        return this.createGroupMembershipAsync(request, null);
    }

    @Override
    public Future<CreateGroupMembershipResult> createGroupMembershipAsync(CreateGroupMembershipRequest request, final AsyncHandler<CreateGroupMembershipRequest, CreateGroupMembershipResult> asyncHandler) {
        final CreateGroupMembershipRequest finalRequest = (CreateGroupMembershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGroupMembershipResult>(){

            @Override
            public CreateGroupMembershipResult call() throws Exception {
                CreateGroupMembershipResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeCreateGroupMembership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request) {
        return this.deleteGroupAsync(request, null);
    }

    @Override
    public Future<DeleteGroupResult> deleteGroupAsync(DeleteGroupRequest request, final AsyncHandler<DeleteGroupRequest, DeleteGroupResult> asyncHandler) {
        final DeleteGroupRequest finalRequest = (DeleteGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGroupResult>(){

            @Override
            public DeleteGroupResult call() throws Exception {
                DeleteGroupResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeDeleteGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGroupMembershipResult> deleteGroupMembershipAsync(DeleteGroupMembershipRequest request) {
        return this.deleteGroupMembershipAsync(request, null);
    }

    @Override
    public Future<DeleteGroupMembershipResult> deleteGroupMembershipAsync(DeleteGroupMembershipRequest request, final AsyncHandler<DeleteGroupMembershipRequest, DeleteGroupMembershipResult> asyncHandler) {
        final DeleteGroupMembershipRequest finalRequest = (DeleteGroupMembershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGroupMembershipResult>(){

            @Override
            public DeleteGroupMembershipResult call() throws Exception {
                DeleteGroupMembershipResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeDeleteGroupMembership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {
        return this.deleteUserAsync(request, null);
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request, final AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {
        final DeleteUserRequest finalRequest = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteUserResult>(){

            @Override
            public DeleteUserResult call() throws Exception {
                DeleteUserResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeDeleteUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGroupResult> describeGroupAsync(DescribeGroupRequest request) {
        return this.describeGroupAsync(request, null);
    }

    @Override
    public Future<DescribeGroupResult> describeGroupAsync(DescribeGroupRequest request, final AsyncHandler<DescribeGroupRequest, DescribeGroupResult> asyncHandler) {
        final DescribeGroupRequest finalRequest = (DescribeGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGroupResult>(){

            @Override
            public DescribeGroupResult call() throws Exception {
                DescribeGroupResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeDescribeGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request) {
        return this.describeUserAsync(request, null);
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request, final AsyncHandler<DescribeUserRequest, DescribeUserResult> asyncHandler) {
        final DescribeUserRequest finalRequest = (DescribeUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUserResult>(){

            @Override
            public DescribeUserResult call() throws Exception {
                DescribeUserResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeDescribeUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDashboardEmbedUrlResult> getDashboardEmbedUrlAsync(GetDashboardEmbedUrlRequest request) {
        return this.getDashboardEmbedUrlAsync(request, null);
    }

    @Override
    public Future<GetDashboardEmbedUrlResult> getDashboardEmbedUrlAsync(GetDashboardEmbedUrlRequest request, final AsyncHandler<GetDashboardEmbedUrlRequest, GetDashboardEmbedUrlResult> asyncHandler) {
        final GetDashboardEmbedUrlRequest finalRequest = (GetDashboardEmbedUrlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDashboardEmbedUrlResult>(){

            @Override
            public GetDashboardEmbedUrlResult call() throws Exception {
                GetDashboardEmbedUrlResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeGetDashboardEmbedUrl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupMembershipsResult> listGroupMembershipsAsync(ListGroupMembershipsRequest request) {
        return this.listGroupMembershipsAsync(request, null);
    }

    @Override
    public Future<ListGroupMembershipsResult> listGroupMembershipsAsync(ListGroupMembershipsRequest request, final AsyncHandler<ListGroupMembershipsRequest, ListGroupMembershipsResult> asyncHandler) {
        final ListGroupMembershipsRequest finalRequest = (ListGroupMembershipsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupMembershipsResult>(){

            @Override
            public ListGroupMembershipsResult call() throws Exception {
                ListGroupMembershipsResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeListGroupMemberships(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request) {
        return this.listGroupsAsync(request, null);
    }

    @Override
    public Future<ListGroupsResult> listGroupsAsync(ListGroupsRequest request, final AsyncHandler<ListGroupsRequest, ListGroupsResult> asyncHandler) {
        final ListGroupsRequest finalRequest = (ListGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGroupsResult>(){

            @Override
            public ListGroupsResult call() throws Exception {
                ListGroupsResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeListGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUserGroupsResult> listUserGroupsAsync(ListUserGroupsRequest request) {
        return this.listUserGroupsAsync(request, null);
    }

    @Override
    public Future<ListUserGroupsResult> listUserGroupsAsync(ListUserGroupsRequest request, final AsyncHandler<ListUserGroupsRequest, ListUserGroupsResult> asyncHandler) {
        final ListUserGroupsRequest finalRequest = (ListUserGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUserGroupsResult>(){

            @Override
            public ListUserGroupsResult call() throws Exception {
                ListUserGroupsResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeListUserGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        final ListUsersRequest finalRequest = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeListUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterUserResult> registerUserAsync(RegisterUserRequest request) {
        return this.registerUserAsync(request, null);
    }

    @Override
    public Future<RegisterUserResult> registerUserAsync(RegisterUserRequest request, final AsyncHandler<RegisterUserRequest, RegisterUserResult> asyncHandler) {
        final RegisterUserRequest finalRequest = (RegisterUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterUserResult>(){

            @Override
            public RegisterUserResult call() throws Exception {
                RegisterUserResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeRegisterUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request) {
        return this.updateGroupAsync(request, null);
    }

    @Override
    public Future<UpdateGroupResult> updateGroupAsync(UpdateGroupRequest request, final AsyncHandler<UpdateGroupRequest, UpdateGroupResult> asyncHandler) {
        final UpdateGroupRequest finalRequest = (UpdateGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGroupResult>(){

            @Override
            public UpdateGroupResult call() throws Exception {
                UpdateGroupResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeUpdateGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {
        return this.updateUserAsync(request, null);
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request, final AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {
        final UpdateUserRequest finalRequest = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserResult>(){

            @Override
            public UpdateUserResult call() throws Exception {
                UpdateUserResult result = null;
                try {
                    result = AmazonQuickSightAsyncClient.this.executeUpdateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

