/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldbsession;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.qldbsession.AmazonQLDBSessionAsync;
import com.amazonaws.services.qldbsession.AmazonQLDBSessionAsyncClientBuilder;
import com.amazonaws.services.qldbsession.AmazonQLDBSessionClient;
import com.amazonaws.services.qldbsession.model.SendCommandRequest;
import com.amazonaws.services.qldbsession.model.SendCommandResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonQLDBSessionAsyncClient
extends AmazonQLDBSessionClient
implements AmazonQLDBSessionAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonQLDBSessionAsyncClientBuilder asyncBuilder() {
        return AmazonQLDBSessionAsyncClientBuilder.standard();
    }

    AmazonQLDBSessionAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonQLDBSessionAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<SendCommandResult> sendCommandAsync(SendCommandRequest request) {
        return this.sendCommandAsync(request, null);
    }

    @Override
    public Future<SendCommandResult> sendCommandAsync(SendCommandRequest request, final AsyncHandler<SendCommandRequest, SendCommandResult> asyncHandler) {
        final SendCommandRequest finalRequest = (SendCommandRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendCommandResult>(){

            @Override
            public SendCommandResult call() throws Exception {
                SendCommandResult result = null;
                try {
                    result = AmazonQLDBSessionAsyncClient.this.executeSendCommand(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

