/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qconnect.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NotifyRecommendationsReceivedRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String assistantId;
    private List<String> recommendationIds;
    private String sessionId;

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public NotifyRecommendationsReceivedRequest withAssistantId(String assistantId) {
        this.setAssistantId(assistantId);
        return this;
    }

    public List<String> getRecommendationIds() {
        return this.recommendationIds;
    }

    public void setRecommendationIds(Collection<String> recommendationIds) {
        if (recommendationIds == null) {
            this.recommendationIds = null;
            return;
        }
        this.recommendationIds = new ArrayList<String>(recommendationIds);
    }

    public NotifyRecommendationsReceivedRequest withRecommendationIds(String ... recommendationIds) {
        if (this.recommendationIds == null) {
            this.setRecommendationIds(new ArrayList<String>(recommendationIds.length));
        }
        for (String ele : recommendationIds) {
            this.recommendationIds.add(ele);
        }
        return this;
    }

    public NotifyRecommendationsReceivedRequest withRecommendationIds(Collection<String> recommendationIds) {
        this.setRecommendationIds(recommendationIds);
        return this;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public NotifyRecommendationsReceivedRequest withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssistantId() != null) {
            sb.append("AssistantId: ").append(this.getAssistantId()).append(",");
        }
        if (this.getRecommendationIds() != null) {
            sb.append("RecommendationIds: ").append(this.getRecommendationIds()).append(",");
        }
        if (this.getSessionId() != null) {
            sb.append("SessionId: ").append(this.getSessionId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyRecommendationsReceivedRequest)) {
            return false;
        }
        NotifyRecommendationsReceivedRequest other = (NotifyRecommendationsReceivedRequest)obj;
        if (other.getAssistantId() == null ^ this.getAssistantId() == null) {
            return false;
        }
        if (other.getAssistantId() != null && !other.getAssistantId().equals(this.getAssistantId())) {
            return false;
        }
        if (other.getRecommendationIds() == null ^ this.getRecommendationIds() == null) {
            return false;
        }
        if (other.getRecommendationIds() != null && !other.getRecommendationIds().equals(this.getRecommendationIds())) {
            return false;
        }
        if (other.getSessionId() == null ^ this.getSessionId() == null) {
            return false;
        }
        return other.getSessionId() == null || other.getSessionId().equals(this.getSessionId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssistantId() == null ? 0 : this.getAssistantId().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationIds() == null ? 0 : this.getRecommendationIds().hashCode());
        hashCode = 31 * hashCode + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        return hashCode;
    }

    public NotifyRecommendationsReceivedRequest clone() {
        return (NotifyRecommendationsReceivedRequest)super.clone();
    }
}

