/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qconnect.model.SessionIntegrationConfiguration;
import com.amazonaws.services.qconnect.model.transform.SessionDataMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SessionData
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private SessionIntegrationConfiguration integrationConfiguration;
    private String name;
    private String sessionArn;
    private String sessionId;
    private Map<String, String> tags;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public SessionData withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setIntegrationConfiguration(SessionIntegrationConfiguration integrationConfiguration) {
        this.integrationConfiguration = integrationConfiguration;
    }

    public SessionIntegrationConfiguration getIntegrationConfiguration() {
        return this.integrationConfiguration;
    }

    public SessionData withIntegrationConfiguration(SessionIntegrationConfiguration integrationConfiguration) {
        this.setIntegrationConfiguration(integrationConfiguration);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SessionData withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSessionArn(String sessionArn) {
        this.sessionArn = sessionArn;
    }

    public String getSessionArn() {
        return this.sessionArn;
    }

    public SessionData withSessionArn(String sessionArn) {
        this.setSessionArn(sessionArn);
        return this;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public SessionData withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public SessionData withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public SessionData addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public SessionData clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getIntegrationConfiguration() != null) {
            sb.append("IntegrationConfiguration: ").append(this.getIntegrationConfiguration()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSessionArn() != null) {
            sb.append("SessionArn: ").append(this.getSessionArn()).append(",");
        }
        if (this.getSessionId() != null) {
            sb.append("SessionId: ").append(this.getSessionId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionData)) {
            return false;
        }
        SessionData other = (SessionData)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getIntegrationConfiguration() == null ^ this.getIntegrationConfiguration() == null) {
            return false;
        }
        if (other.getIntegrationConfiguration() != null && !other.getIntegrationConfiguration().equals(this.getIntegrationConfiguration())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSessionArn() == null ^ this.getSessionArn() == null) {
            return false;
        }
        if (other.getSessionArn() != null && !other.getSessionArn().equals(this.getSessionArn())) {
            return false;
        }
        if (other.getSessionId() == null ^ this.getSessionId() == null) {
            return false;
        }
        if (other.getSessionId() != null && !other.getSessionId().equals(this.getSessionId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrationConfiguration() == null ? 0 : this.getIntegrationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSessionArn() == null ? 0 : this.getSessionArn().hashCode());
        hashCode = 31 * hashCode + (this.getSessionId() == null ? 0 : this.getSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public SessionData clone() {
        try {
            return (SessionData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SessionDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

