/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qconnect.model.transform.GroupingConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String criteria;
    private List<String> values;

    public void setCriteria(String criteria) {
        this.criteria = criteria;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public GroupingConfiguration withCriteria(String criteria) {
        this.setCriteria(criteria);
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<String>(values);
    }

    public GroupingConfiguration withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public GroupingConfiguration withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCriteria() != null) {
            sb.append("Criteria: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingConfiguration)) {
            return false;
        }
        GroupingConfiguration other = (GroupingConfiguration)obj;
        if (other.getCriteria() == null ^ this.getCriteria() == null) {
            return false;
        }
        if (other.getCriteria() != null && !other.getCriteria().equals(this.getCriteria())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCriteria() == null ? 0 : this.getCriteria().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public GroupingConfiguration clone() {
        try {
            return (GroupingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

