/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qbusiness.model.AccessControl;
import com.amazonaws.services.qbusiness.model.MemberRelation;
import com.amazonaws.services.qbusiness.model.transform.AccessConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AccessConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AccessControl> accessControls;
    private String memberRelation;

    public List<AccessControl> getAccessControls() {
        return this.accessControls;
    }

    public void setAccessControls(Collection<AccessControl> accessControls) {
        if (accessControls == null) {
            this.accessControls = null;
            return;
        }
        this.accessControls = new ArrayList<AccessControl>(accessControls);
    }

    public AccessConfiguration withAccessControls(AccessControl ... accessControls) {
        if (this.accessControls == null) {
            this.setAccessControls(new ArrayList<AccessControl>(accessControls.length));
        }
        for (AccessControl ele : accessControls) {
            this.accessControls.add(ele);
        }
        return this;
    }

    public AccessConfiguration withAccessControls(Collection<AccessControl> accessControls) {
        this.setAccessControls(accessControls);
        return this;
    }

    public void setMemberRelation(String memberRelation) {
        this.memberRelation = memberRelation;
    }

    public String getMemberRelation() {
        return this.memberRelation;
    }

    public AccessConfiguration withMemberRelation(String memberRelation) {
        this.setMemberRelation(memberRelation);
        return this;
    }

    public AccessConfiguration withMemberRelation(MemberRelation memberRelation) {
        this.memberRelation = memberRelation.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessControls() != null) {
            sb.append("AccessControls: ").append(this.getAccessControls()).append(",");
        }
        if (this.getMemberRelation() != null) {
            sb.append("MemberRelation: ").append(this.getMemberRelation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessConfiguration)) {
            return false;
        }
        AccessConfiguration other = (AccessConfiguration)obj;
        if (other.getAccessControls() == null ^ this.getAccessControls() == null) {
            return false;
        }
        if (other.getAccessControls() != null && !other.getAccessControls().equals(this.getAccessControls())) {
            return false;
        }
        if (other.getMemberRelation() == null ^ this.getMemberRelation() == null) {
            return false;
        }
        return other.getMemberRelation() == null || other.getMemberRelation().equals(this.getMemberRelation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessControls() == null ? 0 : this.getAccessControls().hashCode());
        hashCode = 31 * hashCode + (this.getMemberRelation() == null ? 0 : this.getMemberRelation().hashCode());
        return hashCode;
    }

    public AccessConfiguration clone() {
        try {
            return (AccessConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccessConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

