/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qbusiness.model.MemberRelation;
import com.amazonaws.services.qbusiness.model.Principal;
import com.amazonaws.services.qbusiness.model.transform.AccessControlMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AccessControl
implements Serializable,
Cloneable,
StructuredPojo {
    private String memberRelation;
    private List<Principal> principals;

    public void setMemberRelation(String memberRelation) {
        this.memberRelation = memberRelation;
    }

    public String getMemberRelation() {
        return this.memberRelation;
    }

    public AccessControl withMemberRelation(String memberRelation) {
        this.setMemberRelation(memberRelation);
        return this;
    }

    public AccessControl withMemberRelation(MemberRelation memberRelation) {
        this.memberRelation = memberRelation.toString();
        return this;
    }

    public List<Principal> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Collection<Principal> principals) {
        if (principals == null) {
            this.principals = null;
            return;
        }
        this.principals = new ArrayList<Principal>(principals);
    }

    public AccessControl withPrincipals(Principal ... principals) {
        if (this.principals == null) {
            this.setPrincipals(new ArrayList<Principal>(principals.length));
        }
        for (Principal ele : principals) {
            this.principals.add(ele);
        }
        return this;
    }

    public AccessControl withPrincipals(Collection<Principal> principals) {
        this.setPrincipals(principals);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMemberRelation() != null) {
            sb.append("MemberRelation: ").append(this.getMemberRelation()).append(",");
        }
        if (this.getPrincipals() != null) {
            sb.append("Principals: ").append(this.getPrincipals());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControl)) {
            return false;
        }
        AccessControl other = (AccessControl)obj;
        if (other.getMemberRelation() == null ^ this.getMemberRelation() == null) {
            return false;
        }
        if (other.getMemberRelation() != null && !other.getMemberRelation().equals(this.getMemberRelation())) {
            return false;
        }
        if (other.getPrincipals() == null ^ this.getPrincipals() == null) {
            return false;
        }
        return other.getPrincipals() == null || other.getPrincipals().equals(this.getPrincipals());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMemberRelation() == null ? 0 : this.getMemberRelation().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipals() == null ? 0 : this.getPrincipals().hashCode());
        return hashCode;
    }

    public AccessControl clone() {
        try {
            return (AccessControl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccessControlMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

