/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.qbusiness.model.Conversation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListConversationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Conversation> conversations;
    private String nextToken;

    public List<Conversation> getConversations() {
        return this.conversations;
    }

    public void setConversations(Collection<Conversation> conversations) {
        if (conversations == null) {
            this.conversations = null;
            return;
        }
        this.conversations = new ArrayList<Conversation>(conversations);
    }

    public ListConversationsResult withConversations(Conversation ... conversations) {
        if (this.conversations == null) {
            this.setConversations(new ArrayList<Conversation>(conversations.length));
        }
        for (Conversation ele : conversations) {
            this.conversations.add(ele);
        }
        return this;
    }

    public ListConversationsResult withConversations(Collection<Conversation> conversations) {
        this.setConversations(conversations);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListConversationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConversations() != null) {
            sb.append("Conversations: ").append(this.getConversations()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConversationsResult)) {
            return false;
        }
        ListConversationsResult other = (ListConversationsResult)obj;
        if (other.getConversations() == null ^ this.getConversations() == null) {
            return false;
        }
        if (other.getConversations() != null && !other.getConversations().equals(this.getConversations())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConversations() == null ? 0 : this.getConversations().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListConversationsResult clone() {
        try {
            return (ListConversationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

