/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Managed Service for Prometheus is a serverless, Prometheus-compatible monitoring service for container metrics
 * that makes it easier to securely monitor container environments at scale. With Amazon Managed Service for Prometheus,
 * you can use the same open-source Prometheus data model and query language that you use today to monitor the
 * performance of your containerized workloads, and also enjoy improved scalability, availability, and security without
 * having to manage the underlying infrastructure.
 * </p>
 * <p>
 * For more information about Amazon Managed Service for Prometheus, see the <a
 * href="https://docs.aws.amazon.com/prometheus/latest/userguide/what-is-Amazon-Managed-Service-Prometheus.html">Amazon
 * Managed Service for Prometheus</a> User Guide.
 * </p>
 * <p>
 * Amazon Managed Service for Prometheus includes two APIs.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Use the Amazon Web Services API described in this guide to manage Amazon Managed Service for Prometheus resources,
 * such as workspaces, rule groups, and alert managers.
 * </p>
 * </li>
 * <li>
 * <p>
 * Use the <a href=
 * "https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-Prometheus-Compatible-Apis"
 * >Prometheus-compatible API</a> to work within your Prometheus workspace.
 * </p>
 * </li>
 * </ul>
 */
package com.amazonaws.services.prometheus;

