/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.prometheus.model.WorkspaceStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateWorkspaceResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String arn;
    private String kmsKeyArn;
    private WorkspaceStatus status;
    private Map<String, String> tags;
    private String workspaceId;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public CreateWorkspaceResult withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    public CreateWorkspaceResult withKmsKeyArn(String kmsKeyArn) {
        this.setKmsKeyArn(kmsKeyArn);
        return this;
    }

    public void setStatus(WorkspaceStatus status) {
        this.status = status;
    }

    public WorkspaceStatus getStatus() {
        return this.status;
    }

    public CreateWorkspaceResult withStatus(WorkspaceStatus status) {
        this.setStatus(status);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateWorkspaceResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateWorkspaceResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateWorkspaceResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public CreateWorkspaceResult withWorkspaceId(String workspaceId) {
        this.setWorkspaceId(workspaceId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getKmsKeyArn() != null) {
            sb.append("KmsKeyArn: ").append(this.getKmsKeyArn()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getWorkspaceId() != null) {
            sb.append("WorkspaceId: ").append(this.getWorkspaceId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceResult)) {
            return false;
        }
        CreateWorkspaceResult other = (CreateWorkspaceResult)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null) {
            return false;
        }
        if (other.getKmsKeyArn() != null && !other.getKmsKeyArn().equals(this.getKmsKeyArn())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getWorkspaceId() == null ^ this.getWorkspaceId() == null) {
            return false;
        }
        return other.getWorkspaceId() == null || other.getWorkspaceId().equals(this.getWorkspaceId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyArn() == null ? 0 : this.getKmsKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceId() == null ? 0 : this.getWorkspaceId().hashCode());
        return hashCode;
    }

    public CreateWorkspaceResult clone() {
        try {
            return (CreateWorkspaceResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

