/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.prometheus.model.WorkspaceDescription;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class WorkspaceDescriptionMarshaller {
    private static final MarshallingInfo<String> WORKSPACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workspaceId").build();
    private static final MarshallingInfo<String> ALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alias").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> PROMETHEUSENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prometheusEndpoint").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final WorkspaceDescriptionMarshaller instance = new WorkspaceDescriptionMarshaller();

    public static WorkspaceDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(WorkspaceDescription workspaceDescription, ProtocolMarshaller protocolMarshaller) {
        if (workspaceDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)workspaceDescription.getWorkspaceId(), WORKSPACEID_BINDING);
            protocolMarshaller.marshall((Object)workspaceDescription.getAlias(), ALIAS_BINDING);
            protocolMarshaller.marshall((Object)workspaceDescription.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)workspaceDescription.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)workspaceDescription.getPrometheusEndpoint(), PROMETHEUSENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)workspaceDescription.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(workspaceDescription.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

