/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.prometheus.model.WorkspaceSummary;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class WorkspaceSummaryMarshaller {
    private static final MarshallingInfo<String> ALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alias").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> WORKSPACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("workspaceId").build();
    private static final WorkspaceSummaryMarshaller instance = new WorkspaceSummaryMarshaller();

    public static WorkspaceSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(WorkspaceSummary workspaceSummary, ProtocolMarshaller protocolMarshaller) {
        if (workspaceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)workspaceSummary.getAlias(), ALIAS_BINDING);
            protocolMarshaller.marshall((Object)workspaceSummary.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)workspaceSummary.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)workspaceSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(workspaceSummary.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)workspaceSummary.getWorkspaceId(), WORKSPACEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

