/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.prometheus.AmazonPrometheusAsync;
import com.amazonaws.services.prometheus.AmazonPrometheusAsyncClientBuilder;
import com.amazonaws.services.prometheus.AmazonPrometheusClient;
import com.amazonaws.services.prometheus.model.CreateWorkspaceRequest;
import com.amazonaws.services.prometheus.model.CreateWorkspaceResult;
import com.amazonaws.services.prometheus.model.DeleteWorkspaceRequest;
import com.amazonaws.services.prometheus.model.DeleteWorkspaceResult;
import com.amazonaws.services.prometheus.model.DescribeWorkspaceRequest;
import com.amazonaws.services.prometheus.model.DescribeWorkspaceResult;
import com.amazonaws.services.prometheus.model.ListWorkspacesRequest;
import com.amazonaws.services.prometheus.model.ListWorkspacesResult;
import com.amazonaws.services.prometheus.model.UpdateWorkspaceAliasRequest;
import com.amazonaws.services.prometheus.model.UpdateWorkspaceAliasResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPrometheusAsyncClient
extends AmazonPrometheusClient
implements AmazonPrometheusAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonPrometheusAsyncClientBuilder asyncBuilder() {
        return AmazonPrometheusAsyncClientBuilder.standard();
    }

    AmazonPrometheusAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonPrometheusAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateWorkspaceResult> createWorkspaceAsync(CreateWorkspaceRequest request) {
        return this.createWorkspaceAsync(request, null);
    }

    @Override
    public Future<CreateWorkspaceResult> createWorkspaceAsync(CreateWorkspaceRequest request, final AsyncHandler<CreateWorkspaceRequest, CreateWorkspaceResult> asyncHandler) {
        final CreateWorkspaceRequest finalRequest = (CreateWorkspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkspaceResult>(){

            @Override
            public CreateWorkspaceResult call() throws Exception {
                CreateWorkspaceResult result = null;
                try {
                    result = AmazonPrometheusAsyncClient.this.executeCreateWorkspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWorkspaceResult> deleteWorkspaceAsync(DeleteWorkspaceRequest request) {
        return this.deleteWorkspaceAsync(request, null);
    }

    @Override
    public Future<DeleteWorkspaceResult> deleteWorkspaceAsync(DeleteWorkspaceRequest request, final AsyncHandler<DeleteWorkspaceRequest, DeleteWorkspaceResult> asyncHandler) {
        final DeleteWorkspaceRequest finalRequest = (DeleteWorkspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWorkspaceResult>(){

            @Override
            public DeleteWorkspaceResult call() throws Exception {
                DeleteWorkspaceResult result = null;
                try {
                    result = AmazonPrometheusAsyncClient.this.executeDeleteWorkspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeWorkspaceResult> describeWorkspaceAsync(DescribeWorkspaceRequest request) {
        return this.describeWorkspaceAsync(request, null);
    }

    @Override
    public Future<DescribeWorkspaceResult> describeWorkspaceAsync(DescribeWorkspaceRequest request, final AsyncHandler<DescribeWorkspaceRequest, DescribeWorkspaceResult> asyncHandler) {
        final DescribeWorkspaceRequest finalRequest = (DescribeWorkspaceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeWorkspaceResult>(){

            @Override
            public DescribeWorkspaceResult call() throws Exception {
                DescribeWorkspaceResult result = null;
                try {
                    result = AmazonPrometheusAsyncClient.this.executeDescribeWorkspace(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkspacesResult> listWorkspacesAsync(ListWorkspacesRequest request) {
        return this.listWorkspacesAsync(request, null);
    }

    @Override
    public Future<ListWorkspacesResult> listWorkspacesAsync(ListWorkspacesRequest request, final AsyncHandler<ListWorkspacesRequest, ListWorkspacesResult> asyncHandler) {
        final ListWorkspacesRequest finalRequest = (ListWorkspacesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkspacesResult>(){

            @Override
            public ListWorkspacesResult call() throws Exception {
                ListWorkspacesResult result = null;
                try {
                    result = AmazonPrometheusAsyncClient.this.executeListWorkspaces(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateWorkspaceAliasResult> updateWorkspaceAliasAsync(UpdateWorkspaceAliasRequest request) {
        return this.updateWorkspaceAliasAsync(request, null);
    }

    @Override
    public Future<UpdateWorkspaceAliasResult> updateWorkspaceAliasAsync(UpdateWorkspaceAliasRequest request, final AsyncHandler<UpdateWorkspaceAliasRequest, UpdateWorkspaceAliasResult> asyncHandler) {
        final UpdateWorkspaceAliasRequest finalRequest = (UpdateWorkspaceAliasRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateWorkspaceAliasResult>(){

            @Override
            public UpdateWorkspaceAliasResult call() throws Exception {
                UpdateWorkspaceAliasResult result = null;
                try {
                    result = AmazonPrometheusAsyncClient.this.executeUpdateWorkspaceAlias(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

