/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.private5g.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.private5g.model.Order;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListOrdersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Order> orders;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListOrdersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(Collection<Order> orders) {
        if (orders == null) {
            this.orders = null;
            return;
        }
        this.orders = new ArrayList<Order>(orders);
    }

    public ListOrdersResult withOrders(Order ... orders) {
        if (this.orders == null) {
            this.setOrders(new ArrayList<Order>(orders.length));
        }
        for (Order ele : orders) {
            this.orders.add(ele);
        }
        return this;
    }

    public ListOrdersResult withOrders(Collection<Order> orders) {
        this.setOrders(orders);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getOrders() != null) {
            sb.append("Orders: ").append(this.getOrders());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrdersResult)) {
            return false;
        }
        ListOrdersResult other = (ListOrdersResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getOrders() == null ^ this.getOrders() == null) {
            return false;
        }
        return other.getOrders() == null || other.getOrders().equals(this.getOrders());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getOrders() == null ? 0 : this.getOrders().hashCode());
        return hashCode;
    }

    public ListOrdersResult clone() {
        try {
            return (ListOrdersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

