/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.private5g.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.private5g.model.NetworkResource;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class NetworkResourceMarshaller {
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> HEALTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("health").build();
    private static final MarshallingInfo<String> MODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("model").build();
    private static final MarshallingInfo<String> NETWORKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkArn").build();
    private static final MarshallingInfo<String> NETWORKRESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkResourceArn").build();
    private static final MarshallingInfo<String> NETWORKSITEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkSiteArn").build();
    private static final MarshallingInfo<String> ORDERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("orderArn").build();
    private static final MarshallingInfo<StructuredPojo> POSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("position").build();
    private static final MarshallingInfo<String> SERIALNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serialNumber").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> STATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusReason").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> VENDOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendor").build();
    private static final NetworkResourceMarshaller instance = new NetworkResourceMarshaller();

    public static NetworkResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(NetworkResource networkResource, ProtocolMarshaller protocolMarshaller) {
        if (networkResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(networkResource.getAttributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getHealth(), HEALTH_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getModel(), MODEL_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getNetworkArn(), NETWORKARN_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getNetworkResourceArn(), NETWORKRESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getNetworkSiteArn(), NETWORKSITEARN_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getOrderArn(), ORDERARN_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getPosition(), POSITION_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getSerialNumber(), SERIALNUMBER_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getStatusReason(), STATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)networkResource.getVendor(), VENDOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

