/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.polly.AmazonPollyAsync;
import com.amazonaws.services.polly.AmazonPollyAsyncClientBuilder;
import com.amazonaws.services.polly.AmazonPollyClient;
import com.amazonaws.services.polly.model.DeleteLexiconRequest;
import com.amazonaws.services.polly.model.DeleteLexiconResult;
import com.amazonaws.services.polly.model.DescribeVoicesRequest;
import com.amazonaws.services.polly.model.DescribeVoicesResult;
import com.amazonaws.services.polly.model.GetLexiconRequest;
import com.amazonaws.services.polly.model.GetLexiconResult;
import com.amazonaws.services.polly.model.GetSpeechSynthesisTaskRequest;
import com.amazonaws.services.polly.model.GetSpeechSynthesisTaskResult;
import com.amazonaws.services.polly.model.ListLexiconsRequest;
import com.amazonaws.services.polly.model.ListLexiconsResult;
import com.amazonaws.services.polly.model.ListSpeechSynthesisTasksRequest;
import com.amazonaws.services.polly.model.ListSpeechSynthesisTasksResult;
import com.amazonaws.services.polly.model.PutLexiconRequest;
import com.amazonaws.services.polly.model.PutLexiconResult;
import com.amazonaws.services.polly.model.StartSpeechSynthesisTaskRequest;
import com.amazonaws.services.polly.model.StartSpeechSynthesisTaskResult;
import com.amazonaws.services.polly.model.SynthesizeSpeechRequest;
import com.amazonaws.services.polly.model.SynthesizeSpeechResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPollyAsyncClient
extends AmazonPollyClient
implements AmazonPollyAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonPollyAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonPollyAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonPollyAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonPollyAsyncClientBuilder asyncBuilder() {
        return AmazonPollyAsyncClientBuilder.standard();
    }

    AmazonPollyAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonPollyAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteLexiconResult> deleteLexiconAsync(DeleteLexiconRequest request) {
        return this.deleteLexiconAsync(request, null);
    }

    @Override
    public Future<DeleteLexiconResult> deleteLexiconAsync(DeleteLexiconRequest request, final AsyncHandler<DeleteLexiconRequest, DeleteLexiconResult> asyncHandler) {
        final DeleteLexiconRequest finalRequest = (DeleteLexiconRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLexiconResult>(){

            @Override
            public DeleteLexiconResult call() throws Exception {
                DeleteLexiconResult result = null;
                try {
                    result = AmazonPollyAsyncClient.this.executeDeleteLexicon(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVoicesResult> describeVoicesAsync(DescribeVoicesRequest request) {
        return this.describeVoicesAsync(request, null);
    }

    @Override
    public Future<DescribeVoicesResult> describeVoicesAsync(DescribeVoicesRequest request, final AsyncHandler<DescribeVoicesRequest, DescribeVoicesResult> asyncHandler) {
        final DescribeVoicesRequest finalRequest = (DescribeVoicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeVoicesResult>(){

            @Override
            public DescribeVoicesResult call() throws Exception {
                DescribeVoicesResult result = null;
                try {
                    result = AmazonPollyAsyncClient.this.executeDescribeVoices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLexiconResult> getLexiconAsync(GetLexiconRequest request) {
        return this.getLexiconAsync(request, null);
    }

    @Override
    public Future<GetLexiconResult> getLexiconAsync(GetLexiconRequest request, final AsyncHandler<GetLexiconRequest, GetLexiconResult> asyncHandler) {
        final GetLexiconRequest finalRequest = (GetLexiconRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLexiconResult>(){

            @Override
            public GetLexiconResult call() throws Exception {
                GetLexiconResult result = null;
                try {
                    result = AmazonPollyAsyncClient.this.executeGetLexicon(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSpeechSynthesisTaskResult> getSpeechSynthesisTaskAsync(GetSpeechSynthesisTaskRequest request) {
        return this.getSpeechSynthesisTaskAsync(request, null);
    }

    @Override
    public Future<GetSpeechSynthesisTaskResult> getSpeechSynthesisTaskAsync(GetSpeechSynthesisTaskRequest request, final AsyncHandler<GetSpeechSynthesisTaskRequest, GetSpeechSynthesisTaskResult> asyncHandler) {
        final GetSpeechSynthesisTaskRequest finalRequest = (GetSpeechSynthesisTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSpeechSynthesisTaskResult>(){

            @Override
            public GetSpeechSynthesisTaskResult call() throws Exception {
                GetSpeechSynthesisTaskResult result = null;
                try {
                    result = AmazonPollyAsyncClient.this.executeGetSpeechSynthesisTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLexiconsResult> listLexiconsAsync(ListLexiconsRequest request) {
        return this.listLexiconsAsync(request, null);
    }

    @Override
    public Future<ListLexiconsResult> listLexiconsAsync(ListLexiconsRequest request, final AsyncHandler<ListLexiconsRequest, ListLexiconsResult> asyncHandler) {
        final ListLexiconsRequest finalRequest = (ListLexiconsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLexiconsResult>(){

            @Override
            public ListLexiconsResult call() throws Exception {
                ListLexiconsResult result = null;
                try {
                    result = AmazonPollyAsyncClient.this.executeListLexicons(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSpeechSynthesisTasksResult> listSpeechSynthesisTasksAsync(ListSpeechSynthesisTasksRequest request) {
        return this.listSpeechSynthesisTasksAsync(request, null);
    }

    @Override
    public Future<ListSpeechSynthesisTasksResult> listSpeechSynthesisTasksAsync(ListSpeechSynthesisTasksRequest request, final AsyncHandler<ListSpeechSynthesisTasksRequest, ListSpeechSynthesisTasksResult> asyncHandler) {
        final ListSpeechSynthesisTasksRequest finalRequest = (ListSpeechSynthesisTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSpeechSynthesisTasksResult>(){

            @Override
            public ListSpeechSynthesisTasksResult call() throws Exception {
                ListSpeechSynthesisTasksResult result = null;
                try {
                    result = AmazonPollyAsyncClient.this.executeListSpeechSynthesisTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLexiconResult> putLexiconAsync(PutLexiconRequest request) {
        return this.putLexiconAsync(request, null);
    }

    @Override
    public Future<PutLexiconResult> putLexiconAsync(PutLexiconRequest request, final AsyncHandler<PutLexiconRequest, PutLexiconResult> asyncHandler) {
        final PutLexiconRequest finalRequest = (PutLexiconRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutLexiconResult>(){

            @Override
            public PutLexiconResult call() throws Exception {
                PutLexiconResult result = null;
                try {
                    result = AmazonPollyAsyncClient.this.executePutLexicon(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSpeechSynthesisTaskResult> startSpeechSynthesisTaskAsync(StartSpeechSynthesisTaskRequest request) {
        return this.startSpeechSynthesisTaskAsync(request, null);
    }

    @Override
    public Future<StartSpeechSynthesisTaskResult> startSpeechSynthesisTaskAsync(StartSpeechSynthesisTaskRequest request, final AsyncHandler<StartSpeechSynthesisTaskRequest, StartSpeechSynthesisTaskResult> asyncHandler) {
        final StartSpeechSynthesisTaskRequest finalRequest = (StartSpeechSynthesisTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSpeechSynthesisTaskResult>(){

            @Override
            public StartSpeechSynthesisTaskResult call() throws Exception {
                StartSpeechSynthesisTaskResult result = null;
                try {
                    result = AmazonPollyAsyncClient.this.executeStartSpeechSynthesisTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SynthesizeSpeechResult> synthesizeSpeechAsync(SynthesizeSpeechRequest request) {
        return this.synthesizeSpeechAsync(request, null);
    }

    @Override
    public Future<SynthesizeSpeechResult> synthesizeSpeechAsync(SynthesizeSpeechRequest request, final AsyncHandler<SynthesizeSpeechRequest, SynthesizeSpeechResult> asyncHandler) {
        final SynthesizeSpeechRequest finalRequest = (SynthesizeSpeechRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SynthesizeSpeechResult>(){

            @Override
            public SynthesizeSpeechResult call() throws Exception {
                SynthesizeSpeechResult result = null;
                try {
                    result = AmazonPollyAsyncClient.this.executeSynthesizeSpeech(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

