/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.polly.model.DescribeVoicesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeVoicesRequestMarshaller
implements Marshaller<Request<DescribeVoicesRequest>, DescribeVoicesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeVoicesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeVoicesRequest> marshall(DescribeVoicesRequest describeVoicesRequest) {
        if (describeVoicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVoicesRequest, "AmazonPolly");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/voices";
        request.setResourcePath(uriResourcePath);
        if (describeVoicesRequest.getLanguageCode() != null) {
            request.addParameter("LanguageCode", StringUtils.fromString((String)describeVoicesRequest.getLanguageCode()));
        }
        if (describeVoicesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVoicesRequest.getNextToken()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

