/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.polly.model.Engine;
import com.amazonaws.services.polly.model.LanguageCode;
import com.amazonaws.services.polly.model.OutputFormat;
import com.amazonaws.services.polly.model.SpeechMarkType;
import com.amazonaws.services.polly.model.TaskStatus;
import com.amazonaws.services.polly.model.TextType;
import com.amazonaws.services.polly.model.VoiceId;
import com.amazonaws.services.polly.model.transform.SynthesisTaskMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SynthesisTask
implements Serializable,
Cloneable,
StructuredPojo {
    private String engine;
    private String taskId;
    private String taskStatus;
    private String taskStatusReason;
    private String outputUri;
    private Date creationTime;
    private Integer requestCharacters;
    private String snsTopicArn;
    private List<String> lexiconNames;
    private String outputFormat;
    private String sampleRate;
    private List<String> speechMarkTypes;
    private String textType;
    private String voiceId;
    private String languageCode;

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public SynthesisTask withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public SynthesisTask withEngine(Engine engine) {
        this.engine = engine.toString();
        return this;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public SynthesisTask withTaskId(String taskId) {
        this.setTaskId(taskId);
        return this;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public SynthesisTask withTaskStatus(String taskStatus) {
        this.setTaskStatus(taskStatus);
        return this;
    }

    public SynthesisTask withTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus.toString();
        return this;
    }

    public void setTaskStatusReason(String taskStatusReason) {
        this.taskStatusReason = taskStatusReason;
    }

    public String getTaskStatusReason() {
        return this.taskStatusReason;
    }

    public SynthesisTask withTaskStatusReason(String taskStatusReason) {
        this.setTaskStatusReason(taskStatusReason);
        return this;
    }

    public void setOutputUri(String outputUri) {
        this.outputUri = outputUri;
    }

    public String getOutputUri() {
        return this.outputUri;
    }

    public SynthesisTask withOutputUri(String outputUri) {
        this.setOutputUri(outputUri);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public SynthesisTask withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setRequestCharacters(Integer requestCharacters) {
        this.requestCharacters = requestCharacters;
    }

    public Integer getRequestCharacters() {
        return this.requestCharacters;
    }

    public SynthesisTask withRequestCharacters(Integer requestCharacters) {
        this.setRequestCharacters(requestCharacters);
        return this;
    }

    public void setSnsTopicArn(String snsTopicArn) {
        this.snsTopicArn = snsTopicArn;
    }

    public String getSnsTopicArn() {
        return this.snsTopicArn;
    }

    public SynthesisTask withSnsTopicArn(String snsTopicArn) {
        this.setSnsTopicArn(snsTopicArn);
        return this;
    }

    public List<String> getLexiconNames() {
        return this.lexiconNames;
    }

    public void setLexiconNames(Collection<String> lexiconNames) {
        if (lexiconNames == null) {
            this.lexiconNames = null;
            return;
        }
        this.lexiconNames = new ArrayList<String>(lexiconNames);
    }

    public SynthesisTask withLexiconNames(String ... lexiconNames) {
        if (this.lexiconNames == null) {
            this.setLexiconNames(new ArrayList<String>(lexiconNames.length));
        }
        for (String ele : lexiconNames) {
            this.lexiconNames.add(ele);
        }
        return this;
    }

    public SynthesisTask withLexiconNames(Collection<String> lexiconNames) {
        this.setLexiconNames(lexiconNames);
        return this;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public SynthesisTask withOutputFormat(String outputFormat) {
        this.setOutputFormat(outputFormat);
        return this;
    }

    public SynthesisTask withOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat.toString();
        return this;
    }

    public void setSampleRate(String sampleRate) {
        this.sampleRate = sampleRate;
    }

    public String getSampleRate() {
        return this.sampleRate;
    }

    public SynthesisTask withSampleRate(String sampleRate) {
        this.setSampleRate(sampleRate);
        return this;
    }

    public List<String> getSpeechMarkTypes() {
        return this.speechMarkTypes;
    }

    public void setSpeechMarkTypes(Collection<String> speechMarkTypes) {
        if (speechMarkTypes == null) {
            this.speechMarkTypes = null;
            return;
        }
        this.speechMarkTypes = new ArrayList<String>(speechMarkTypes);
    }

    public SynthesisTask withSpeechMarkTypes(String ... speechMarkTypes) {
        if (this.speechMarkTypes == null) {
            this.setSpeechMarkTypes(new ArrayList<String>(speechMarkTypes.length));
        }
        for (String ele : speechMarkTypes) {
            this.speechMarkTypes.add(ele);
        }
        return this;
    }

    public SynthesisTask withSpeechMarkTypes(Collection<String> speechMarkTypes) {
        this.setSpeechMarkTypes(speechMarkTypes);
        return this;
    }

    public SynthesisTask withSpeechMarkTypes(SpeechMarkType ... speechMarkTypes) {
        ArrayList<String> speechMarkTypesCopy = new ArrayList<String>(speechMarkTypes.length);
        for (SpeechMarkType value : speechMarkTypes) {
            speechMarkTypesCopy.add(value.toString());
        }
        if (this.getSpeechMarkTypes() == null) {
            this.setSpeechMarkTypes(speechMarkTypesCopy);
        } else {
            this.getSpeechMarkTypes().addAll(speechMarkTypesCopy);
        }
        return this;
    }

    public void setTextType(String textType) {
        this.textType = textType;
    }

    public String getTextType() {
        return this.textType;
    }

    public SynthesisTask withTextType(String textType) {
        this.setTextType(textType);
        return this;
    }

    public SynthesisTask withTextType(TextType textType) {
        this.textType = textType.toString();
        return this;
    }

    public void setVoiceId(String voiceId) {
        this.voiceId = voiceId;
    }

    public String getVoiceId() {
        return this.voiceId;
    }

    public SynthesisTask withVoiceId(String voiceId) {
        this.setVoiceId(voiceId);
        return this;
    }

    public SynthesisTask withVoiceId(VoiceId voiceId) {
        this.voiceId = voiceId.toString();
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public SynthesisTask withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public SynthesisTask withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getTaskId() != null) {
            sb.append("TaskId: ").append(this.getTaskId()).append(",");
        }
        if (this.getTaskStatus() != null) {
            sb.append("TaskStatus: ").append(this.getTaskStatus()).append(",");
        }
        if (this.getTaskStatusReason() != null) {
            sb.append("TaskStatusReason: ").append(this.getTaskStatusReason()).append(",");
        }
        if (this.getOutputUri() != null) {
            sb.append("OutputUri: ").append(this.getOutputUri()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getRequestCharacters() != null) {
            sb.append("RequestCharacters: ").append(this.getRequestCharacters()).append(",");
        }
        if (this.getSnsTopicArn() != null) {
            sb.append("SnsTopicArn: ").append(this.getSnsTopicArn()).append(",");
        }
        if (this.getLexiconNames() != null) {
            sb.append("LexiconNames: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOutputFormat() != null) {
            sb.append("OutputFormat: ").append(this.getOutputFormat()).append(",");
        }
        if (this.getSampleRate() != null) {
            sb.append("SampleRate: ").append(this.getSampleRate()).append(",");
        }
        if (this.getSpeechMarkTypes() != null) {
            sb.append("SpeechMarkTypes: ").append(this.getSpeechMarkTypes()).append(",");
        }
        if (this.getTextType() != null) {
            sb.append("TextType: ").append(this.getTextType()).append(",");
        }
        if (this.getVoiceId() != null) {
            sb.append("VoiceId: ").append(this.getVoiceId()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SynthesisTask)) {
            return false;
        }
        SynthesisTask other = (SynthesisTask)obj;
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getTaskId() == null ^ this.getTaskId() == null) {
            return false;
        }
        if (other.getTaskId() != null && !other.getTaskId().equals(this.getTaskId())) {
            return false;
        }
        if (other.getTaskStatus() == null ^ this.getTaskStatus() == null) {
            return false;
        }
        if (other.getTaskStatus() != null && !other.getTaskStatus().equals(this.getTaskStatus())) {
            return false;
        }
        if (other.getTaskStatusReason() == null ^ this.getTaskStatusReason() == null) {
            return false;
        }
        if (other.getTaskStatusReason() != null && !other.getTaskStatusReason().equals(this.getTaskStatusReason())) {
            return false;
        }
        if (other.getOutputUri() == null ^ this.getOutputUri() == null) {
            return false;
        }
        if (other.getOutputUri() != null && !other.getOutputUri().equals(this.getOutputUri())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getRequestCharacters() == null ^ this.getRequestCharacters() == null) {
            return false;
        }
        if (other.getRequestCharacters() != null && !other.getRequestCharacters().equals(this.getRequestCharacters())) {
            return false;
        }
        if (other.getSnsTopicArn() == null ^ this.getSnsTopicArn() == null) {
            return false;
        }
        if (other.getSnsTopicArn() != null && !other.getSnsTopicArn().equals(this.getSnsTopicArn())) {
            return false;
        }
        if (other.getLexiconNames() == null ^ this.getLexiconNames() == null) {
            return false;
        }
        if (other.getLexiconNames() != null && !other.getLexiconNames().equals(this.getLexiconNames())) {
            return false;
        }
        if (other.getOutputFormat() == null ^ this.getOutputFormat() == null) {
            return false;
        }
        if (other.getOutputFormat() != null && !other.getOutputFormat().equals(this.getOutputFormat())) {
            return false;
        }
        if (other.getSampleRate() == null ^ this.getSampleRate() == null) {
            return false;
        }
        if (other.getSampleRate() != null && !other.getSampleRate().equals(this.getSampleRate())) {
            return false;
        }
        if (other.getSpeechMarkTypes() == null ^ this.getSpeechMarkTypes() == null) {
            return false;
        }
        if (other.getSpeechMarkTypes() != null && !other.getSpeechMarkTypes().equals(this.getSpeechMarkTypes())) {
            return false;
        }
        if (other.getTextType() == null ^ this.getTextType() == null) {
            return false;
        }
        if (other.getTextType() != null && !other.getTextType().equals(this.getTextType())) {
            return false;
        }
        if (other.getVoiceId() == null ^ this.getVoiceId() == null) {
            return false;
        }
        if (other.getVoiceId() != null && !other.getVoiceId().equals(this.getVoiceId())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        return other.getLanguageCode() == null || other.getLanguageCode().equals(this.getLanguageCode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getTaskId() == null ? 0 : this.getTaskId().hashCode());
        hashCode = 31 * hashCode + (this.getTaskStatus() == null ? 0 : this.getTaskStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTaskStatusReason() == null ? 0 : this.getTaskStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getOutputUri() == null ? 0 : this.getOutputUri().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getRequestCharacters() == null ? 0 : this.getRequestCharacters().hashCode());
        hashCode = 31 * hashCode + (this.getSnsTopicArn() == null ? 0 : this.getSnsTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getLexiconNames() == null ? 0 : this.getLexiconNames().hashCode());
        hashCode = 31 * hashCode + (this.getOutputFormat() == null ? 0 : this.getOutputFormat().hashCode());
        hashCode = 31 * hashCode + (this.getSampleRate() == null ? 0 : this.getSampleRate().hashCode());
        hashCode = 31 * hashCode + (this.getSpeechMarkTypes() == null ? 0 : this.getSpeechMarkTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTextType() == null ? 0 : this.getTextType().hashCode());
        hashCode = 31 * hashCode + (this.getVoiceId() == null ? 0 : this.getVoiceId().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        return hashCode;
    }

    public SynthesisTask clone() {
        try {
            return (SynthesisTask)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SynthesisTaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

