/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.polly.model.ListLexiconsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListLexiconsRequestMarshaller
implements Marshaller<Request<ListLexiconsRequest>, ListLexiconsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListLexiconsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListLexiconsRequest> marshall(ListLexiconsRequest listLexiconsRequest) {
        if (listLexiconsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listLexiconsRequest, "AmazonPolly");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/lexicons";
        request.setResourcePath(uriResourcePath);
        if (listLexiconsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listLexiconsRequest.getNextToken()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

