/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pipes.model.CloudwatchLogsLogDestination;
import com.amazonaws.services.pipes.model.FirehoseLogDestination;
import com.amazonaws.services.pipes.model.IncludeExecutionDataOption;
import com.amazonaws.services.pipes.model.LogLevel;
import com.amazonaws.services.pipes.model.S3LogDestination;
import com.amazonaws.services.pipes.model.transform.PipeLogConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PipeLogConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private S3LogDestination s3LogDestination;
    private FirehoseLogDestination firehoseLogDestination;
    private CloudwatchLogsLogDestination cloudwatchLogsLogDestination;
    private String level;
    private List<String> includeExecutionData;

    public void setS3LogDestination(S3LogDestination s3LogDestination) {
        this.s3LogDestination = s3LogDestination;
    }

    public S3LogDestination getS3LogDestination() {
        return this.s3LogDestination;
    }

    public PipeLogConfiguration withS3LogDestination(S3LogDestination s3LogDestination) {
        this.setS3LogDestination(s3LogDestination);
        return this;
    }

    public void setFirehoseLogDestination(FirehoseLogDestination firehoseLogDestination) {
        this.firehoseLogDestination = firehoseLogDestination;
    }

    public FirehoseLogDestination getFirehoseLogDestination() {
        return this.firehoseLogDestination;
    }

    public PipeLogConfiguration withFirehoseLogDestination(FirehoseLogDestination firehoseLogDestination) {
        this.setFirehoseLogDestination(firehoseLogDestination);
        return this;
    }

    public void setCloudwatchLogsLogDestination(CloudwatchLogsLogDestination cloudwatchLogsLogDestination) {
        this.cloudwatchLogsLogDestination = cloudwatchLogsLogDestination;
    }

    public CloudwatchLogsLogDestination getCloudwatchLogsLogDestination() {
        return this.cloudwatchLogsLogDestination;
    }

    public PipeLogConfiguration withCloudwatchLogsLogDestination(CloudwatchLogsLogDestination cloudwatchLogsLogDestination) {
        this.setCloudwatchLogsLogDestination(cloudwatchLogsLogDestination);
        return this;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    public PipeLogConfiguration withLevel(String level) {
        this.setLevel(level);
        return this;
    }

    public PipeLogConfiguration withLevel(LogLevel level) {
        this.level = level.toString();
        return this;
    }

    public List<String> getIncludeExecutionData() {
        return this.includeExecutionData;
    }

    public void setIncludeExecutionData(Collection<String> includeExecutionData) {
        if (includeExecutionData == null) {
            this.includeExecutionData = null;
            return;
        }
        this.includeExecutionData = new ArrayList<String>(includeExecutionData);
    }

    public PipeLogConfiguration withIncludeExecutionData(String ... includeExecutionData) {
        if (this.includeExecutionData == null) {
            this.setIncludeExecutionData(new ArrayList<String>(includeExecutionData.length));
        }
        for (String ele : includeExecutionData) {
            this.includeExecutionData.add(ele);
        }
        return this;
    }

    public PipeLogConfiguration withIncludeExecutionData(Collection<String> includeExecutionData) {
        this.setIncludeExecutionData(includeExecutionData);
        return this;
    }

    public PipeLogConfiguration withIncludeExecutionData(IncludeExecutionDataOption ... includeExecutionData) {
        ArrayList<String> includeExecutionDataCopy = new ArrayList<String>(includeExecutionData.length);
        for (IncludeExecutionDataOption value : includeExecutionData) {
            includeExecutionDataCopy.add(value.toString());
        }
        if (this.getIncludeExecutionData() == null) {
            this.setIncludeExecutionData(includeExecutionDataCopy);
        } else {
            this.getIncludeExecutionData().addAll(includeExecutionDataCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3LogDestination() != null) {
            sb.append("S3LogDestination: ").append(this.getS3LogDestination()).append(",");
        }
        if (this.getFirehoseLogDestination() != null) {
            sb.append("FirehoseLogDestination: ").append(this.getFirehoseLogDestination()).append(",");
        }
        if (this.getCloudwatchLogsLogDestination() != null) {
            sb.append("CloudwatchLogsLogDestination: ").append(this.getCloudwatchLogsLogDestination()).append(",");
        }
        if (this.getLevel() != null) {
            sb.append("Level: ").append(this.getLevel()).append(",");
        }
        if (this.getIncludeExecutionData() != null) {
            sb.append("IncludeExecutionData: ").append(this.getIncludeExecutionData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeLogConfiguration)) {
            return false;
        }
        PipeLogConfiguration other = (PipeLogConfiguration)obj;
        if (other.getS3LogDestination() == null ^ this.getS3LogDestination() == null) {
            return false;
        }
        if (other.getS3LogDestination() != null && !other.getS3LogDestination().equals(this.getS3LogDestination())) {
            return false;
        }
        if (other.getFirehoseLogDestination() == null ^ this.getFirehoseLogDestination() == null) {
            return false;
        }
        if (other.getFirehoseLogDestination() != null && !other.getFirehoseLogDestination().equals(this.getFirehoseLogDestination())) {
            return false;
        }
        if (other.getCloudwatchLogsLogDestination() == null ^ this.getCloudwatchLogsLogDestination() == null) {
            return false;
        }
        if (other.getCloudwatchLogsLogDestination() != null && !other.getCloudwatchLogsLogDestination().equals(this.getCloudwatchLogsLogDestination())) {
            return false;
        }
        if (other.getLevel() == null ^ this.getLevel() == null) {
            return false;
        }
        if (other.getLevel() != null && !other.getLevel().equals(this.getLevel())) {
            return false;
        }
        if (other.getIncludeExecutionData() == null ^ this.getIncludeExecutionData() == null) {
            return false;
        }
        return other.getIncludeExecutionData() == null || other.getIncludeExecutionData().equals(this.getIncludeExecutionData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3LogDestination() == null ? 0 : this.getS3LogDestination().hashCode());
        hashCode = 31 * hashCode + (this.getFirehoseLogDestination() == null ? 0 : this.getFirehoseLogDestination().hashCode());
        hashCode = 31 * hashCode + (this.getCloudwatchLogsLogDestination() == null ? 0 : this.getCloudwatchLogsLogDestination().hashCode());
        hashCode = 31 * hashCode + (this.getLevel() == null ? 0 : this.getLevel().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeExecutionData() == null ? 0 : this.getIncludeExecutionData().hashCode());
        return hashCode;
    }

    public PipeLogConfiguration clone() {
        try {
            return (PipeLogConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipeLogConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

