/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pinpoint.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetRecommenderConfigurationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    private RecommenderConfigurationResponse recommenderConfigurationResponse;

    /**
     * @param recommenderConfigurationResponse
     */

    public void setRecommenderConfigurationResponse(RecommenderConfigurationResponse recommenderConfigurationResponse) {
        this.recommenderConfigurationResponse = recommenderConfigurationResponse;
    }

    /**
     * @return
     */

    public RecommenderConfigurationResponse getRecommenderConfigurationResponse() {
        return this.recommenderConfigurationResponse;
    }

    /**
     * @param recommenderConfigurationResponse
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetRecommenderConfigurationResult withRecommenderConfigurationResponse(RecommenderConfigurationResponse recommenderConfigurationResponse) {
        setRecommenderConfigurationResponse(recommenderConfigurationResponse);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRecommenderConfigurationResponse() != null)
            sb.append("RecommenderConfigurationResponse: ").append(getRecommenderConfigurationResponse());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetRecommenderConfigurationResult == false)
            return false;
        GetRecommenderConfigurationResult other = (GetRecommenderConfigurationResult) obj;
        if (other.getRecommenderConfigurationResponse() == null ^ this.getRecommenderConfigurationResponse() == null)
            return false;
        if (other.getRecommenderConfigurationResponse() != null
                && other.getRecommenderConfigurationResponse().equals(this.getRecommenderConfigurationResponse()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRecommenderConfigurationResponse() == null) ? 0 : getRecommenderConfigurationResponse().hashCode());
        return hashCode;
    }

    @Override
    public GetRecommenderConfigurationResult clone() {
        try {
            return (GetRecommenderConfigurationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
