/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.SegmentGroup;
import java.util.List;

@SdkInternalApi
public class SegmentGroupMarshaller {
    private static final MarshallingInfo<List> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").build();
    private static final MarshallingInfo<List> SOURCESEGMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceSegments").build();
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final SegmentGroupMarshaller instance = new SegmentGroupMarshaller();

    public static SegmentGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(SegmentGroup segmentGroup, ProtocolMarshaller protocolMarshaller) {
        if (segmentGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(segmentGroup.getDimensions(), DIMENSIONS_BINDING);
            protocolMarshaller.marshall(segmentGroup.getSourceSegments(), SOURCESEGMENTS_BINDING);
            protocolMarshaller.marshall((Object)segmentGroup.getSourceType(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)segmentGroup.getType(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

