/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.Action;
import com.amazonaws.services.pinpoint.model.transform.APNSMessageMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class APNSMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private String aPNSPushType;
    private String action;
    private Integer badge;
    private String body;
    private String category;
    private String collapseId;
    private Map<String, String> data;
    private String mediaUrl;
    private String preferredAuthenticationMethod;
    private String priority;
    private String rawContent;
    private Boolean silentPush;
    private String sound;
    private Map<String, List<String>> substitutions;
    private String threadId;
    private Integer timeToLive;
    private String title;
    private String url;

    public void setAPNSPushType(String aPNSPushType) {
        this.aPNSPushType = aPNSPushType;
    }

    public String getAPNSPushType() {
        return this.aPNSPushType;
    }

    public APNSMessage withAPNSPushType(String aPNSPushType) {
        this.setAPNSPushType(aPNSPushType);
        return this;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public APNSMessage withAction(String action) {
        this.setAction(action);
        return this;
    }

    public void setAction(Action action) {
        this.withAction(action);
    }

    public APNSMessage withAction(Action action) {
        this.action = action.toString();
        return this;
    }

    public void setBadge(Integer badge) {
        this.badge = badge;
    }

    public Integer getBadge() {
        return this.badge;
    }

    public APNSMessage withBadge(Integer badge) {
        this.setBadge(badge);
        return this;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public APNSMessage withBody(String body) {
        this.setBody(body);
        return this;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public APNSMessage withCategory(String category) {
        this.setCategory(category);
        return this;
    }

    public void setCollapseId(String collapseId) {
        this.collapseId = collapseId;
    }

    public String getCollapseId() {
        return this.collapseId;
    }

    public APNSMessage withCollapseId(String collapseId) {
        this.setCollapseId(collapseId);
        return this;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public APNSMessage withData(Map<String, String> data) {
        this.setData(data);
        return this;
    }

    public APNSMessage addDataEntry(String key, String value) {
        if (null == this.data) {
            this.data = new HashMap<String, String>();
        }
        if (this.data.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.data.put(key, value);
        return this;
    }

    public APNSMessage clearDataEntries() {
        this.data = null;
        return this;
    }

    public void setMediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
    }

    public String getMediaUrl() {
        return this.mediaUrl;
    }

    public APNSMessage withMediaUrl(String mediaUrl) {
        this.setMediaUrl(mediaUrl);
        return this;
    }

    public void setPreferredAuthenticationMethod(String preferredAuthenticationMethod) {
        this.preferredAuthenticationMethod = preferredAuthenticationMethod;
    }

    public String getPreferredAuthenticationMethod() {
        return this.preferredAuthenticationMethod;
    }

    public APNSMessage withPreferredAuthenticationMethod(String preferredAuthenticationMethod) {
        this.setPreferredAuthenticationMethod(preferredAuthenticationMethod);
        return this;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getPriority() {
        return this.priority;
    }

    public APNSMessage withPriority(String priority) {
        this.setPriority(priority);
        return this;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public APNSMessage withRawContent(String rawContent) {
        this.setRawContent(rawContent);
        return this;
    }

    public void setSilentPush(Boolean silentPush) {
        this.silentPush = silentPush;
    }

    public Boolean getSilentPush() {
        return this.silentPush;
    }

    public APNSMessage withSilentPush(Boolean silentPush) {
        this.setSilentPush(silentPush);
        return this;
    }

    public Boolean isSilentPush() {
        return this.silentPush;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public String getSound() {
        return this.sound;
    }

    public APNSMessage withSound(String sound) {
        this.setSound(sound);
        return this;
    }

    public Map<String, List<String>> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, List<String>> substitutions) {
        this.substitutions = substitutions;
    }

    public APNSMessage withSubstitutions(Map<String, List<String>> substitutions) {
        this.setSubstitutions(substitutions);
        return this;
    }

    public APNSMessage addSubstitutionsEntry(String key, List<String> value) {
        if (null == this.substitutions) {
            this.substitutions = new HashMap<String, List<String>>();
        }
        if (this.substitutions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutions.put(key, value);
        return this;
    }

    public APNSMessage clearSubstitutionsEntries() {
        this.substitutions = null;
        return this;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public APNSMessage withThreadId(String threadId) {
        this.setThreadId(threadId);
        return this;
    }

    public void setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public APNSMessage withTimeToLive(Integer timeToLive) {
        this.setTimeToLive(timeToLive);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public APNSMessage withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public APNSMessage withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAPNSPushType() != null) {
            sb.append("APNSPushType: ").append(this.getAPNSPushType()).append(",");
        }
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getBadge() != null) {
            sb.append("Badge: ").append(this.getBadge()).append(",");
        }
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getCategory() != null) {
            sb.append("Category: ").append(this.getCategory()).append(",");
        }
        if (this.getCollapseId() != null) {
            sb.append("CollapseId: ").append(this.getCollapseId()).append(",");
        }
        if (this.getData() != null) {
            sb.append("Data: ").append(this.getData()).append(",");
        }
        if (this.getMediaUrl() != null) {
            sb.append("MediaUrl: ").append(this.getMediaUrl()).append(",");
        }
        if (this.getPreferredAuthenticationMethod() != null) {
            sb.append("PreferredAuthenticationMethod: ").append(this.getPreferredAuthenticationMethod()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority()).append(",");
        }
        if (this.getRawContent() != null) {
            sb.append("RawContent: ").append(this.getRawContent()).append(",");
        }
        if (this.getSilentPush() != null) {
            sb.append("SilentPush: ").append(this.getSilentPush()).append(",");
        }
        if (this.getSound() != null) {
            sb.append("Sound: ").append(this.getSound()).append(",");
        }
        if (this.getSubstitutions() != null) {
            sb.append("Substitutions: ").append(this.getSubstitutions()).append(",");
        }
        if (this.getThreadId() != null) {
            sb.append("ThreadId: ").append(this.getThreadId()).append(",");
        }
        if (this.getTimeToLive() != null) {
            sb.append("TimeToLive: ").append(this.getTimeToLive()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSMessage)) {
            return false;
        }
        APNSMessage other = (APNSMessage)obj;
        if (other.getAPNSPushType() == null ^ this.getAPNSPushType() == null) {
            return false;
        }
        if (other.getAPNSPushType() != null && !other.getAPNSPushType().equals(this.getAPNSPushType())) {
            return false;
        }
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getBadge() == null ^ this.getBadge() == null) {
            return false;
        }
        if (other.getBadge() != null && !other.getBadge().equals(this.getBadge())) {
            return false;
        }
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getCategory() == null ^ this.getCategory() == null) {
            return false;
        }
        if (other.getCategory() != null && !other.getCategory().equals(this.getCategory())) {
            return false;
        }
        if (other.getCollapseId() == null ^ this.getCollapseId() == null) {
            return false;
        }
        if (other.getCollapseId() != null && !other.getCollapseId().equals(this.getCollapseId())) {
            return false;
        }
        if (other.getData() == null ^ this.getData() == null) {
            return false;
        }
        if (other.getData() != null && !other.getData().equals(this.getData())) {
            return false;
        }
        if (other.getMediaUrl() == null ^ this.getMediaUrl() == null) {
            return false;
        }
        if (other.getMediaUrl() != null && !other.getMediaUrl().equals(this.getMediaUrl())) {
            return false;
        }
        if (other.getPreferredAuthenticationMethod() == null ^ this.getPreferredAuthenticationMethod() == null) {
            return false;
        }
        if (other.getPreferredAuthenticationMethod() != null && !other.getPreferredAuthenticationMethod().equals(this.getPreferredAuthenticationMethod())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getRawContent() == null ^ this.getRawContent() == null) {
            return false;
        }
        if (other.getRawContent() != null && !other.getRawContent().equals(this.getRawContent())) {
            return false;
        }
        if (other.getSilentPush() == null ^ this.getSilentPush() == null) {
            return false;
        }
        if (other.getSilentPush() != null && !other.getSilentPush().equals(this.getSilentPush())) {
            return false;
        }
        if (other.getSound() == null ^ this.getSound() == null) {
            return false;
        }
        if (other.getSound() != null && !other.getSound().equals(this.getSound())) {
            return false;
        }
        if (other.getSubstitutions() == null ^ this.getSubstitutions() == null) {
            return false;
        }
        if (other.getSubstitutions() != null && !other.getSubstitutions().equals(this.getSubstitutions())) {
            return false;
        }
        if (other.getThreadId() == null ^ this.getThreadId() == null) {
            return false;
        }
        if (other.getThreadId() != null && !other.getThreadId().equals(this.getThreadId())) {
            return false;
        }
        if (other.getTimeToLive() == null ^ this.getTimeToLive() == null) {
            return false;
        }
        if (other.getTimeToLive() != null && !other.getTimeToLive().equals(this.getTimeToLive())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        return other.getUrl() == null || other.getUrl().equals(this.getUrl());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAPNSPushType() == null ? 0 : this.getAPNSPushType().hashCode());
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getBadge() == null ? 0 : this.getBadge().hashCode());
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        hashCode = 31 * hashCode + (this.getCollapseId() == null ? 0 : this.getCollapseId().hashCode());
        hashCode = 31 * hashCode + (this.getData() == null ? 0 : this.getData().hashCode());
        hashCode = 31 * hashCode + (this.getMediaUrl() == null ? 0 : this.getMediaUrl().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredAuthenticationMethod() == null ? 0 : this.getPreferredAuthenticationMethod().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getRawContent() == null ? 0 : this.getRawContent().hashCode());
        hashCode = 31 * hashCode + (this.getSilentPush() == null ? 0 : this.getSilentPush().hashCode());
        hashCode = 31 * hashCode + (this.getSound() == null ? 0 : this.getSound().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutions() == null ? 0 : this.getSubstitutions().hashCode());
        hashCode = 31 * hashCode + (this.getThreadId() == null ? 0 : this.getThreadId().hashCode());
        hashCode = 31 * hashCode + (this.getTimeToLive() == null ? 0 : this.getTimeToLive().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        return hashCode;
    }

    public APNSMessage clone() {
        try {
            return (APNSMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        APNSMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

