/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.APNSChannelRequest;
import com.amazonaws.services.pinpoint.model.UpdateApnsChannelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateApnsChannelRequestMarshaller
implements Marshaller<Request<UpdateApnsChannelRequest>, UpdateApnsChannelRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateApnsChannelRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateApnsChannelRequest> marshall(UpdateApnsChannelRequest updateApnsChannelRequest) {
        if (updateApnsChannelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateApnsChannelRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/v1/apps/{application-id}/channels/apns";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", updateApnsChannelRequest.getApplicationId());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            APNSChannelRequest aPNSChannelRequest = updateApnsChannelRequest.getAPNSChannelRequest();
            if (aPNSChannelRequest != null) {
                jsonGenerator.writeStartObject();
                if (aPNSChannelRequest.getCertificate() != null) {
                    jsonGenerator.writeFieldName("Certificate").writeValue(aPNSChannelRequest.getCertificate());
                }
                if (aPNSChannelRequest.getPrivateKey() != null) {
                    jsonGenerator.writeFieldName("PrivateKey").writeValue(aPNSChannelRequest.getPrivateKey());
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

