/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.CampaignResponse;
import com.amazonaws.services.pinpoint.model.TreatmentResource;
import com.amazonaws.services.pinpoint.model.transform.CampaignLimitsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.CampaignStateJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.MessageConfigurationJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.ScheduleJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.TreatmentResourceJsonMarshaller;
import java.util.List;

public class CampaignResponseJsonMarshaller {
    private static CampaignResponseJsonMarshaller instance;

    public void marshall(CampaignResponse campaignResponse, StructuredJsonGenerator jsonGenerator) {
        if (campaignResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<TreatmentResource> additionalTreatmentsList = campaignResponse.getAdditionalTreatments();
            if (additionalTreatmentsList != null) {
                jsonGenerator.writeFieldName("AdditionalTreatments");
                jsonGenerator.writeStartArray();
                for (TreatmentResource additionalTreatmentsListValue : additionalTreatmentsList) {
                    if (additionalTreatmentsListValue == null) continue;
                    TreatmentResourceJsonMarshaller.getInstance().marshall(additionalTreatmentsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (campaignResponse.getApplicationId() != null) {
                jsonGenerator.writeFieldName("ApplicationId").writeValue(campaignResponse.getApplicationId());
            }
            if (campaignResponse.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(campaignResponse.getCreationDate());
            }
            if (campaignResponse.getDefaultState() != null) {
                jsonGenerator.writeFieldName("DefaultState");
                CampaignStateJsonMarshaller.getInstance().marshall(campaignResponse.getDefaultState(), jsonGenerator);
            }
            if (campaignResponse.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(campaignResponse.getDescription());
            }
            if (campaignResponse.getHoldoutPercent() != null) {
                jsonGenerator.writeFieldName("HoldoutPercent").writeValue(campaignResponse.getHoldoutPercent().intValue());
            }
            if (campaignResponse.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(campaignResponse.getId());
            }
            if (campaignResponse.getIsPaused() != null) {
                jsonGenerator.writeFieldName("IsPaused").writeValue(campaignResponse.getIsPaused().booleanValue());
            }
            if (campaignResponse.getLastModifiedDate() != null) {
                jsonGenerator.writeFieldName("LastModifiedDate").writeValue(campaignResponse.getLastModifiedDate());
            }
            if (campaignResponse.getLimits() != null) {
                jsonGenerator.writeFieldName("Limits");
                CampaignLimitsJsonMarshaller.getInstance().marshall(campaignResponse.getLimits(), jsonGenerator);
            }
            if (campaignResponse.getMessageConfiguration() != null) {
                jsonGenerator.writeFieldName("MessageConfiguration");
                MessageConfigurationJsonMarshaller.getInstance().marshall(campaignResponse.getMessageConfiguration(), jsonGenerator);
            }
            if (campaignResponse.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(campaignResponse.getName());
            }
            if (campaignResponse.getSchedule() != null) {
                jsonGenerator.writeFieldName("Schedule");
                ScheduleJsonMarshaller.getInstance().marshall(campaignResponse.getSchedule(), jsonGenerator);
            }
            if (campaignResponse.getSegmentId() != null) {
                jsonGenerator.writeFieldName("SegmentId").writeValue(campaignResponse.getSegmentId());
            }
            if (campaignResponse.getSegmentVersion() != null) {
                jsonGenerator.writeFieldName("SegmentVersion").writeValue(campaignResponse.getSegmentVersion().intValue());
            }
            if (campaignResponse.getState() != null) {
                jsonGenerator.writeFieldName("State");
                CampaignStateJsonMarshaller.getInstance().marshall(campaignResponse.getState(), jsonGenerator);
            }
            if (campaignResponse.getTreatmentDescription() != null) {
                jsonGenerator.writeFieldName("TreatmentDescription").writeValue(campaignResponse.getTreatmentDescription());
            }
            if (campaignResponse.getTreatmentName() != null) {
                jsonGenerator.writeFieldName("TreatmentName").writeValue(campaignResponse.getTreatmentName());
            }
            if (campaignResponse.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(campaignResponse.getVersion().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CampaignResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CampaignResponseJsonMarshaller();
        }
        return instance;
    }
}

