/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.transform.EmailTemplateRequestMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EmailTemplateRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String htmlPart;
    private String subject;
    private Map<String, String> tags;
    private String textPart;

    public void setHtmlPart(String htmlPart) {
        this.htmlPart = htmlPart;
    }

    public String getHtmlPart() {
        return this.htmlPart;
    }

    public EmailTemplateRequest withHtmlPart(String htmlPart) {
        this.setHtmlPart(htmlPart);
        return this;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public EmailTemplateRequest withSubject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public EmailTemplateRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public EmailTemplateRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public EmailTemplateRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTextPart(String textPart) {
        this.textPart = textPart;
    }

    public String getTextPart() {
        return this.textPart;
    }

    public EmailTemplateRequest withTextPart(String textPart) {
        this.setTextPart(textPart);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHtmlPart() != null) {
            sb.append("HtmlPart: ").append(this.getHtmlPart()).append(",");
        }
        if (this.getSubject() != null) {
            sb.append("Subject: ").append(this.getSubject()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTextPart() != null) {
            sb.append("TextPart: ").append(this.getTextPart());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailTemplateRequest)) {
            return false;
        }
        EmailTemplateRequest other = (EmailTemplateRequest)obj;
        if (other.getHtmlPart() == null ^ this.getHtmlPart() == null) {
            return false;
        }
        if (other.getHtmlPart() != null && !other.getHtmlPart().equals(this.getHtmlPart())) {
            return false;
        }
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        if (other.getSubject() != null && !other.getSubject().equals(this.getSubject())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTextPart() == null ^ this.getTextPart() == null) {
            return false;
        }
        return other.getTextPart() == null || other.getTextPart().equals(this.getTextPart());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHtmlPart() == null ? 0 : this.getHtmlPart().hashCode());
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTextPart() == null ? 0 : this.getTextPart().hashCode());
        return hashCode;
    }

    public EmailTemplateRequest clone() {
        try {
            return (EmailTemplateRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmailTemplateRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

