/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.EndpointBatchItem;
import com.amazonaws.services.pinpoint.model.EndpointBatchRequest;
import com.amazonaws.services.pinpoint.model.UpdateEndpointsBatchRequest;
import com.amazonaws.services.pinpoint.model.transform.EndpointBatchItemJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateEndpointsBatchRequestMarshaller
implements Marshaller<Request<UpdateEndpointsBatchRequest>, UpdateEndpointsBatchRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateEndpointsBatchRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateEndpointsBatchRequest> marshall(UpdateEndpointsBatchRequest updateEndpointsBatchRequest) {
        if (updateEndpointsBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateEndpointsBatchRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/v1/apps/{application-id}/endpoints";
        uriResourcePath = uriResourcePath.replace("{application-id}", updateEndpointsBatchRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)updateEndpointsBatchRequest.getApplicationId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            EndpointBatchRequest endpointBatchRequest = updateEndpointsBatchRequest.getEndpointBatchRequest();
            if (endpointBatchRequest != null) {
                jsonGenerator.writeStartObject();
                List<EndpointBatchItem> itemList = endpointBatchRequest.getItem();
                if (itemList != null) {
                    jsonGenerator.writeFieldName("Item");
                    jsonGenerator.writeStartArray();
                    for (EndpointBatchItem itemListValue : itemList) {
                        if (itemListValue == null) continue;
                        EndpointBatchItemJsonMarshaller.getInstance().marshall(itemListValue, jsonGenerator);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

