/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.GetSegmentVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetSegmentVersionsRequestMarshaller
implements Marshaller<Request<GetSegmentVersionsRequest>, GetSegmentVersionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetSegmentVersionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetSegmentVersionsRequest> marshall(GetSegmentVersionsRequest getSegmentVersionsRequest) {
        if (getSegmentVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSegmentVersionsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}/versions";
        uriResourcePath = uriResourcePath.replace("{application-id}", getSegmentVersionsRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getSegmentVersionsRequest.getApplicationId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{segment-id}", getSegmentVersionsRequest.getSegmentId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getSegmentVersionsRequest.getSegmentId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (getSegmentVersionsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString((String)getSegmentVersionsRequest.getPageSize()));
        }
        if (getSegmentVersionsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString((String)getSegmentVersionsRequest.getToken()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

