/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.ImportJobResponse;
import com.amazonaws.services.pinpoint.model.transform.ImportJobResourceJsonMarshaller;
import java.util.List;

public class ImportJobResponseJsonMarshaller {
    private static ImportJobResponseJsonMarshaller instance;

    public void marshall(ImportJobResponse importJobResponse, StructuredJsonGenerator jsonGenerator) {
        if (importJobResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> failuresList;
            jsonGenerator.writeStartObject();
            if (importJobResponse.getApplicationId() != null) {
                jsonGenerator.writeFieldName("ApplicationId").writeValue(importJobResponse.getApplicationId());
            }
            if (importJobResponse.getCompletedPieces() != null) {
                jsonGenerator.writeFieldName("CompletedPieces").writeValue(importJobResponse.getCompletedPieces().intValue());
            }
            if (importJobResponse.getCompletionDate() != null) {
                jsonGenerator.writeFieldName("CompletionDate").writeValue(importJobResponse.getCompletionDate());
            }
            if (importJobResponse.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(importJobResponse.getCreationDate());
            }
            if (importJobResponse.getDefinition() != null) {
                jsonGenerator.writeFieldName("Definition");
                ImportJobResourceJsonMarshaller.getInstance().marshall(importJobResponse.getDefinition(), jsonGenerator);
            }
            if (importJobResponse.getFailedPieces() != null) {
                jsonGenerator.writeFieldName("FailedPieces").writeValue(importJobResponse.getFailedPieces().intValue());
            }
            if ((failuresList = importJobResponse.getFailures()) != null) {
                jsonGenerator.writeFieldName("Failures");
                jsonGenerator.writeStartArray();
                for (String failuresListValue : failuresList) {
                    if (failuresListValue == null) continue;
                    jsonGenerator.writeValue(failuresListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (importJobResponse.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(importJobResponse.getId());
            }
            if (importJobResponse.getJobStatus() != null) {
                jsonGenerator.writeFieldName("JobStatus").writeValue(importJobResponse.getJobStatus());
            }
            if (importJobResponse.getTotalFailures() != null) {
                jsonGenerator.writeFieldName("TotalFailures").writeValue(importJobResponse.getTotalFailures().intValue());
            }
            if (importJobResponse.getTotalPieces() != null) {
                jsonGenerator.writeFieldName("TotalPieces").writeValue(importJobResponse.getTotalPieces().intValue());
            }
            if (importJobResponse.getTotalProcessed() != null) {
                jsonGenerator.writeFieldName("TotalProcessed").writeValue(importJobResponse.getTotalProcessed().intValue());
            }
            if (importJobResponse.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(importJobResponse.getType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImportJobResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImportJobResponseJsonMarshaller();
        }
        return instance;
    }
}

