/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.SimpleEmail;

@SdkInternalApi
public class SimpleEmailMarshaller {
    private static final MarshallingInfo<StructuredPojo> HTMLPART_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HtmlPart").build();
    private static final MarshallingInfo<StructuredPojo> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subject").build();
    private static final MarshallingInfo<StructuredPojo> TEXTPART_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextPart").build();
    private static final SimpleEmailMarshaller instance = new SimpleEmailMarshaller();

    public static SimpleEmailMarshaller getInstance() {
        return instance;
    }

    public void marshall(SimpleEmail simpleEmail, ProtocolMarshaller protocolMarshaller) {
        if (simpleEmail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)simpleEmail.getHtmlPart(), HTMLPART_BINDING);
            protocolMarshaller.marshall((Object)simpleEmail.getSubject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)simpleEmail.getTextPart(), TEXTPART_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

