/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.transform.EmailMessageMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmailMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private String body;
    private String fromAddress;
    private String htmlBody;
    private Map<String, List<String>> substitutions;
    private String templateArn;
    private String title;

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public EmailMessage withBody(String body) {
        this.setBody(body);
        return this;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public EmailMessage withFromAddress(String fromAddress) {
        this.setFromAddress(fromAddress);
        return this;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public String getHtmlBody() {
        return this.htmlBody;
    }

    public EmailMessage withHtmlBody(String htmlBody) {
        this.setHtmlBody(htmlBody);
        return this;
    }

    public Map<String, List<String>> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, List<String>> substitutions) {
        this.substitutions = substitutions;
    }

    public EmailMessage withSubstitutions(Map<String, List<String>> substitutions) {
        this.setSubstitutions(substitutions);
        return this;
    }

    public EmailMessage addSubstitutionsEntry(String key, List<String> value) {
        if (null == this.substitutions) {
            this.substitutions = new HashMap<String, List<String>>();
        }
        if (this.substitutions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutions.put(key, value);
        return this;
    }

    public EmailMessage clearSubstitutionsEntries() {
        this.substitutions = null;
        return this;
    }

    public void setTemplateArn(String templateArn) {
        this.templateArn = templateArn;
    }

    public String getTemplateArn() {
        return this.templateArn;
    }

    public EmailMessage withTemplateArn(String templateArn) {
        this.setTemplateArn(templateArn);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public EmailMessage withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBody() != null) {
            sb.append("Body: ").append(this.getBody()).append(",");
        }
        if (this.getFromAddress() != null) {
            sb.append("FromAddress: ").append(this.getFromAddress()).append(",");
        }
        if (this.getHtmlBody() != null) {
            sb.append("HtmlBody: ").append(this.getHtmlBody()).append(",");
        }
        if (this.getSubstitutions() != null) {
            sb.append("Substitutions: ").append(this.getSubstitutions()).append(",");
        }
        if (this.getTemplateArn() != null) {
            sb.append("TemplateArn: ").append(this.getTemplateArn()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMessage)) {
            return false;
        }
        EmailMessage other = (EmailMessage)obj;
        if (other.getBody() == null ^ this.getBody() == null) {
            return false;
        }
        if (other.getBody() != null && !other.getBody().equals(this.getBody())) {
            return false;
        }
        if (other.getFromAddress() == null ^ this.getFromAddress() == null) {
            return false;
        }
        if (other.getFromAddress() != null && !other.getFromAddress().equals(this.getFromAddress())) {
            return false;
        }
        if (other.getHtmlBody() == null ^ this.getHtmlBody() == null) {
            return false;
        }
        if (other.getHtmlBody() != null && !other.getHtmlBody().equals(this.getHtmlBody())) {
            return false;
        }
        if (other.getSubstitutions() == null ^ this.getSubstitutions() == null) {
            return false;
        }
        if (other.getSubstitutions() != null && !other.getSubstitutions().equals(this.getSubstitutions())) {
            return false;
        }
        if (other.getTemplateArn() == null ^ this.getTemplateArn() == null) {
            return false;
        }
        if (other.getTemplateArn() != null && !other.getTemplateArn().equals(this.getTemplateArn())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        return other.getTitle() == null || other.getTitle().equals(this.getTitle());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBody() == null ? 0 : this.getBody().hashCode());
        hashCode = 31 * hashCode + (this.getFromAddress() == null ? 0 : this.getFromAddress().hashCode());
        hashCode = 31 * hashCode + (this.getHtmlBody() == null ? 0 : this.getHtmlBody().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutions() == null ? 0 : this.getSubstitutions().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateArn() == null ? 0 : this.getTemplateArn().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        return hashCode;
    }

    public EmailMessage clone() {
        try {
            return (EmailMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmailMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

