/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.MessageResponse;
import java.util.Map;

@SdkInternalApi
public class MessageResponseMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").build();
    private static final MarshallingInfo<String> REQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestId").build();
    private static final MarshallingInfo<Map> RESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Result").build();
    private static final MessageResponseMarshaller instance = new MessageResponseMarshaller();

    public static MessageResponseMarshaller getInstance() {
        return instance;
    }

    public void marshall(MessageResponse messageResponse, ProtocolMarshaller protocolMarshaller) {
        if (messageResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)messageResponse.getApplicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)messageResponse.getRequestId(), REQUESTID_BINDING);
            protocolMarshaller.marshall(messageResponse.getResult(), RESULT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

