/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.ChannelType;
import com.amazonaws.services.pinpoint.model.EndpointDemographic;
import com.amazonaws.services.pinpoint.model.EndpointLocation;
import com.amazonaws.services.pinpoint.model.EndpointUser;
import com.amazonaws.services.pinpoint.model.transform.EndpointResponseMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EndpointResponse
implements Serializable,
Cloneable,
StructuredPojo {
    private String address;
    private String applicationId;
    private Map<String, List<String>> attributes;
    private String channelType;
    private String cohortId;
    private String creationDate;
    private EndpointDemographic demographic;
    private String effectiveDate;
    private String endpointStatus;
    private String id;
    private EndpointLocation location;
    private Map<String, Double> metrics;
    private String optOut;
    private String requestId;
    private String shardId;
    private EndpointUser user;

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public EndpointResponse withAddress(String address) {
        this.setAddress(address);
        return this;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public EndpointResponse withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public EndpointResponse withAttributes(Map<String, List<String>> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public EndpointResponse addAttributesEntry(String key, List<String> value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, List<String>>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public EndpointResponse clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public EndpointResponse withChannelType(String channelType) {
        this.setChannelType(channelType);
        return this;
    }

    @JsonIgnore
    public void setChannelType(ChannelType channelType) {
        this.channelType = channelType.toString();
    }

    public EndpointResponse withChannelType(ChannelType channelType) {
        this.setChannelType(channelType);
        return this;
    }

    public void setCohortId(String cohortId) {
        this.cohortId = cohortId;
    }

    public String getCohortId() {
        return this.cohortId;
    }

    public EndpointResponse withCohortId(String cohortId) {
        this.setCohortId(cohortId);
        return this;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public EndpointResponse withCreationDate(String creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public void setDemographic(EndpointDemographic demographic) {
        this.demographic = demographic;
    }

    public EndpointDemographic getDemographic() {
        return this.demographic;
    }

    public EndpointResponse withDemographic(EndpointDemographic demographic) {
        this.setDemographic(demographic);
        return this;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public EndpointResponse withEffectiveDate(String effectiveDate) {
        this.setEffectiveDate(effectiveDate);
        return this;
    }

    public void setEndpointStatus(String endpointStatus) {
        this.endpointStatus = endpointStatus;
    }

    public String getEndpointStatus() {
        return this.endpointStatus;
    }

    public EndpointResponse withEndpointStatus(String endpointStatus) {
        this.setEndpointStatus(endpointStatus);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public EndpointResponse withId(String id) {
        this.setId(id);
        return this;
    }

    public void setLocation(EndpointLocation location) {
        this.location = location;
    }

    public EndpointLocation getLocation() {
        return this.location;
    }

    public EndpointResponse withLocation(EndpointLocation location) {
        this.setLocation(location);
        return this;
    }

    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Double> metrics) {
        this.metrics = metrics;
    }

    public EndpointResponse withMetrics(Map<String, Double> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public EndpointResponse addMetricsEntry(String key, Double value) {
        if (null == this.metrics) {
            this.metrics = new HashMap<String, Double>();
        }
        if (this.metrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metrics.put(key, value);
        return this;
    }

    public EndpointResponse clearMetricsEntries() {
        this.metrics = null;
        return this;
    }

    public void setOptOut(String optOut) {
        this.optOut = optOut;
    }

    public String getOptOut() {
        return this.optOut;
    }

    public EndpointResponse withOptOut(String optOut) {
        this.setOptOut(optOut);
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public EndpointResponse withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getShardId() {
        return this.shardId;
    }

    public EndpointResponse withShardId(String shardId) {
        this.setShardId(shardId);
        return this;
    }

    public void setUser(EndpointUser user) {
        this.user = user;
    }

    public EndpointUser getUser() {
        return this.user;
    }

    public EndpointResponse withUser(EndpointUser user) {
        this.setUser(user);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddress() != null) {
            sb.append("Address: ").append(this.getAddress()).append(",");
        }
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getChannelType() != null) {
            sb.append("ChannelType: ").append(this.getChannelType()).append(",");
        }
        if (this.getCohortId() != null) {
            sb.append("CohortId: ").append(this.getCohortId()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getDemographic() != null) {
            sb.append("Demographic: ").append(this.getDemographic()).append(",");
        }
        if (this.getEffectiveDate() != null) {
            sb.append("EffectiveDate: ").append(this.getEffectiveDate()).append(",");
        }
        if (this.getEndpointStatus() != null) {
            sb.append("EndpointStatus: ").append(this.getEndpointStatus()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics()).append(",");
        }
        if (this.getOptOut() != null) {
            sb.append("OptOut: ").append(this.getOptOut()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getShardId() != null) {
            sb.append("ShardId: ").append(this.getShardId()).append(",");
        }
        if (this.getUser() != null) {
            sb.append("User: ").append(this.getUser());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointResponse)) {
            return false;
        }
        EndpointResponse other = (EndpointResponse)obj;
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        if (other.getAddress() != null && !other.getAddress().equals(this.getAddress())) {
            return false;
        }
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getChannelType() == null ^ this.getChannelType() == null) {
            return false;
        }
        if (other.getChannelType() != null && !other.getChannelType().equals(this.getChannelType())) {
            return false;
        }
        if (other.getCohortId() == null ^ this.getCohortId() == null) {
            return false;
        }
        if (other.getCohortId() != null && !other.getCohortId().equals(this.getCohortId())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getDemographic() == null ^ this.getDemographic() == null) {
            return false;
        }
        if (other.getDemographic() != null && !other.getDemographic().equals(this.getDemographic())) {
            return false;
        }
        if (other.getEffectiveDate() == null ^ this.getEffectiveDate() == null) {
            return false;
        }
        if (other.getEffectiveDate() != null && !other.getEffectiveDate().equals(this.getEffectiveDate())) {
            return false;
        }
        if (other.getEndpointStatus() == null ^ this.getEndpointStatus() == null) {
            return false;
        }
        if (other.getEndpointStatus() != null && !other.getEndpointStatus().equals(this.getEndpointStatus())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getOptOut() == null ^ this.getOptOut() == null) {
            return false;
        }
        if (other.getOptOut() != null && !other.getOptOut().equals(this.getOptOut())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getShardId() == null ^ this.getShardId() == null) {
            return false;
        }
        if (other.getShardId() != null && !other.getShardId().equals(this.getShardId())) {
            return false;
        }
        if (other.getUser() == null ^ this.getUser() == null) {
            return false;
        }
        return other.getUser() == null || other.getUser().equals(this.getUser());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getChannelType() == null ? 0 : this.getChannelType().hashCode());
        hashCode = 31 * hashCode + (this.getCohortId() == null ? 0 : this.getCohortId().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getDemographic() == null ? 0 : this.getDemographic().hashCode());
        hashCode = 31 * hashCode + (this.getEffectiveDate() == null ? 0 : this.getEffectiveDate().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointStatus() == null ? 0 : this.getEndpointStatus().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getOptOut() == null ? 0 : this.getOptOut().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getShardId() == null ? 0 : this.getShardId().hashCode());
        hashCode = 31 * hashCode + (this.getUser() == null ? 0 : this.getUser().hashCode());
        return hashCode;
    }

    public EndpointResponse clone() {
        try {
            return (EndpointResponse)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

