/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pi.model.DimensionGroupDetail;
import com.amazonaws.services.pi.model.transform.MetricDimensionGroupsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetricDimensionGroups
implements Serializable,
Cloneable,
StructuredPojo {
    private String metric;
    private List<DimensionGroupDetail> groups;

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public String getMetric() {
        return this.metric;
    }

    public MetricDimensionGroups withMetric(String metric) {
        this.setMetric(metric);
        return this;
    }

    public List<DimensionGroupDetail> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<DimensionGroupDetail> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<DimensionGroupDetail>(groups);
    }

    public MetricDimensionGroups withGroups(DimensionGroupDetail ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<DimensionGroupDetail>(groups.length));
        }
        for (DimensionGroupDetail ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public MetricDimensionGroups withGroups(Collection<DimensionGroupDetail> groups) {
        this.setGroups(groups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetric() != null) {
            sb.append("Metric: ").append(this.getMetric()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDimensionGroups)) {
            return false;
        }
        MetricDimensionGroups other = (MetricDimensionGroups)obj;
        if (other.getMetric() == null ^ this.getMetric() == null) {
            return false;
        }
        if (other.getMetric() != null && !other.getMetric().equals(this.getMetric())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        return other.getGroups() == null || other.getGroups().equals(this.getGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetric() == null ? 0 : this.getMetric().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        return hashCode;
    }

    public MetricDimensionGroups clone() {
        try {
            return (MetricDimensionGroups)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricDimensionGroupsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

