/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeevents;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.personalizeevents.AmazonPersonalizeEventsAsync;
import com.amazonaws.services.personalizeevents.AmazonPersonalizeEventsAsyncClientBuilder;
import com.amazonaws.services.personalizeevents.AmazonPersonalizeEventsClient;
import com.amazonaws.services.personalizeevents.model.PutEventsRequest;
import com.amazonaws.services.personalizeevents.model.PutEventsResult;
import com.amazonaws.services.personalizeevents.model.PutItemsRequest;
import com.amazonaws.services.personalizeevents.model.PutItemsResult;
import com.amazonaws.services.personalizeevents.model.PutUsersRequest;
import com.amazonaws.services.personalizeevents.model.PutUsersResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPersonalizeEventsAsyncClient
extends AmazonPersonalizeEventsClient
implements AmazonPersonalizeEventsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonPersonalizeEventsAsyncClientBuilder asyncBuilder() {
        return AmazonPersonalizeEventsAsyncClientBuilder.standard();
    }

    AmazonPersonalizeEventsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonPersonalizeEventsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(PutEventsRequest request) {
        return this.putEventsAsync(request, null);
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(PutEventsRequest request, final AsyncHandler<PutEventsRequest, PutEventsResult> asyncHandler) {
        final PutEventsRequest finalRequest = (PutEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutEventsResult>(){

            @Override
            public PutEventsResult call() throws Exception {
                PutEventsResult result = null;
                try {
                    result = AmazonPersonalizeEventsAsyncClient.this.executePutEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutItemsResult> putItemsAsync(PutItemsRequest request) {
        return this.putItemsAsync(request, null);
    }

    @Override
    public Future<PutItemsResult> putItemsAsync(PutItemsRequest request, final AsyncHandler<PutItemsRequest, PutItemsResult> asyncHandler) {
        final PutItemsRequest finalRequest = (PutItemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutItemsResult>(){

            @Override
            public PutItemsResult call() throws Exception {
                PutItemsResult result = null;
                try {
                    result = AmazonPersonalizeEventsAsyncClient.this.executePutItems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutUsersResult> putUsersAsync(PutUsersRequest request) {
        return this.putUsersAsync(request, null);
    }

    @Override
    public Future<PutUsersResult> putUsersAsync(PutUsersRequest request, final AsyncHandler<PutUsersRequest, PutUsersResult> asyncHandler) {
        final PutUsersRequest finalRequest = (PutUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutUsersResult>(){

            @Override
            public PutUsersResult call() throws Exception {
                PutUsersResult result = null;
                try {
                    result = AmazonPersonalizeEventsAsyncClient.this.executePutUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

