/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.transform.RecommenderConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RecommenderConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> itemExplorationConfig;
    private Integer minRecommendationRequestsPerSecond;

    public Map<String, String> getItemExplorationConfig() {
        return this.itemExplorationConfig;
    }

    public void setItemExplorationConfig(Map<String, String> itemExplorationConfig) {
        this.itemExplorationConfig = itemExplorationConfig;
    }

    public RecommenderConfig withItemExplorationConfig(Map<String, String> itemExplorationConfig) {
        this.setItemExplorationConfig(itemExplorationConfig);
        return this;
    }

    public RecommenderConfig addItemExplorationConfigEntry(String key, String value) {
        if (null == this.itemExplorationConfig) {
            this.itemExplorationConfig = new HashMap<String, String>();
        }
        if (this.itemExplorationConfig.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.itemExplorationConfig.put(key, value);
        return this;
    }

    public RecommenderConfig clearItemExplorationConfigEntries() {
        this.itemExplorationConfig = null;
        return this;
    }

    public void setMinRecommendationRequestsPerSecond(Integer minRecommendationRequestsPerSecond) {
        this.minRecommendationRequestsPerSecond = minRecommendationRequestsPerSecond;
    }

    public Integer getMinRecommendationRequestsPerSecond() {
        return this.minRecommendationRequestsPerSecond;
    }

    public RecommenderConfig withMinRecommendationRequestsPerSecond(Integer minRecommendationRequestsPerSecond) {
        this.setMinRecommendationRequestsPerSecond(minRecommendationRequestsPerSecond);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItemExplorationConfig() != null) {
            sb.append("ItemExplorationConfig: ").append(this.getItemExplorationConfig()).append(",");
        }
        if (this.getMinRecommendationRequestsPerSecond() != null) {
            sb.append("MinRecommendationRequestsPerSecond: ").append(this.getMinRecommendationRequestsPerSecond());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommenderConfig)) {
            return false;
        }
        RecommenderConfig other = (RecommenderConfig)obj;
        if (other.getItemExplorationConfig() == null ^ this.getItemExplorationConfig() == null) {
            return false;
        }
        if (other.getItemExplorationConfig() != null && !other.getItemExplorationConfig().equals(this.getItemExplorationConfig())) {
            return false;
        }
        if (other.getMinRecommendationRequestsPerSecond() == null ^ this.getMinRecommendationRequestsPerSecond() == null) {
            return false;
        }
        return other.getMinRecommendationRequestsPerSecond() == null || other.getMinRecommendationRequestsPerSecond().equals(this.getMinRecommendationRequestsPerSecond());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItemExplorationConfig() == null ? 0 : this.getItemExplorationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getMinRecommendationRequestsPerSecond() == null ? 0 : this.getMinRecommendationRequestsPerSecond().hashCode());
        return hashCode;
    }

    public RecommenderConfig clone() {
        try {
            return (RecommenderConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommenderConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

