/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptographydata.model.WrappedKey;

@SdkInternalApi
public class WrappedKeyMarshaller {
    private static final MarshallingInfo<StructuredPojo> WRAPPEDKEYMATERIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WrappedKeyMaterial").build();
    private static final MarshallingInfo<String> KEYCHECKVALUEALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyCheckValueAlgorithm").build();
    private static final WrappedKeyMarshaller instance = new WrappedKeyMarshaller();

    public static WrappedKeyMarshaller getInstance() {
        return instance;
    }

    public void marshall(WrappedKey wrappedKey, ProtocolMarshaller protocolMarshaller) {
        if (wrappedKey == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)wrappedKey.getWrappedKeyMaterial(), WRAPPEDKEYMATERIAL_BINDING);
            protocolMarshaller.marshall((Object)wrappedKey.getKeyCheckValueAlgorithm(), KEYCHECKVALUEALGORITHM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

