/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.KeyExportability;
import com.amazonaws.services.paymentcryptography.model.KeyModesOfUse;
import com.amazonaws.services.paymentcryptography.model.transform.KeyBlockHeadersMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class KeyBlockHeaders
implements Serializable,
Cloneable,
StructuredPojo {
    private KeyModesOfUse keyModesOfUse;
    private String keyExportability;
    private String keyVersion;
    private Map<String, String> optionalBlocks;

    public void setKeyModesOfUse(KeyModesOfUse keyModesOfUse) {
        this.keyModesOfUse = keyModesOfUse;
    }

    public KeyModesOfUse getKeyModesOfUse() {
        return this.keyModesOfUse;
    }

    public KeyBlockHeaders withKeyModesOfUse(KeyModesOfUse keyModesOfUse) {
        this.setKeyModesOfUse(keyModesOfUse);
        return this;
    }

    public void setKeyExportability(String keyExportability) {
        this.keyExportability = keyExportability;
    }

    public String getKeyExportability() {
        return this.keyExportability;
    }

    public KeyBlockHeaders withKeyExportability(String keyExportability) {
        this.setKeyExportability(keyExportability);
        return this;
    }

    public KeyBlockHeaders withKeyExportability(KeyExportability keyExportability) {
        this.keyExportability = keyExportability.toString();
        return this;
    }

    public void setKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public KeyBlockHeaders withKeyVersion(String keyVersion) {
        this.setKeyVersion(keyVersion);
        return this;
    }

    public Map<String, String> getOptionalBlocks() {
        return this.optionalBlocks;
    }

    public void setOptionalBlocks(Map<String, String> optionalBlocks) {
        this.optionalBlocks = optionalBlocks;
    }

    public KeyBlockHeaders withOptionalBlocks(Map<String, String> optionalBlocks) {
        this.setOptionalBlocks(optionalBlocks);
        return this;
    }

    public KeyBlockHeaders addOptionalBlocksEntry(String key, String value) {
        if (null == this.optionalBlocks) {
            this.optionalBlocks = new HashMap<String, String>();
        }
        if (this.optionalBlocks.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.optionalBlocks.put(key, value);
        return this;
    }

    public KeyBlockHeaders clearOptionalBlocksEntries() {
        this.optionalBlocks = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyModesOfUse() != null) {
            sb.append("KeyModesOfUse: ").append(this.getKeyModesOfUse()).append(",");
        }
        if (this.getKeyExportability() != null) {
            sb.append("KeyExportability: ").append(this.getKeyExportability()).append(",");
        }
        if (this.getKeyVersion() != null) {
            sb.append("KeyVersion: ").append(this.getKeyVersion()).append(",");
        }
        if (this.getOptionalBlocks() != null) {
            sb.append("OptionalBlocks: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyBlockHeaders)) {
            return false;
        }
        KeyBlockHeaders other = (KeyBlockHeaders)obj;
        if (other.getKeyModesOfUse() == null ^ this.getKeyModesOfUse() == null) {
            return false;
        }
        if (other.getKeyModesOfUse() != null && !other.getKeyModesOfUse().equals(this.getKeyModesOfUse())) {
            return false;
        }
        if (other.getKeyExportability() == null ^ this.getKeyExportability() == null) {
            return false;
        }
        if (other.getKeyExportability() != null && !other.getKeyExportability().equals(this.getKeyExportability())) {
            return false;
        }
        if (other.getKeyVersion() == null ^ this.getKeyVersion() == null) {
            return false;
        }
        if (other.getKeyVersion() != null && !other.getKeyVersion().equals(this.getKeyVersion())) {
            return false;
        }
        if (other.getOptionalBlocks() == null ^ this.getOptionalBlocks() == null) {
            return false;
        }
        return other.getOptionalBlocks() == null || other.getOptionalBlocks().equals(this.getOptionalBlocks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyModesOfUse() == null ? 0 : this.getKeyModesOfUse().hashCode());
        hashCode = 31 * hashCode + (this.getKeyExportability() == null ? 0 : this.getKeyExportability().hashCode());
        hashCode = 31 * hashCode + (this.getKeyVersion() == null ? 0 : this.getKeyVersion().hashCode());
        hashCode = 31 * hashCode + (this.getOptionalBlocks() == null ? 0 : this.getOptionalBlocks().hashCode());
        return hashCode;
    }

    public KeyBlockHeaders clone() {
        try {
            return (KeyBlockHeaders)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyBlockHeadersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

