/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.KeyAttributes;
import com.amazonaws.services.paymentcryptography.model.KeyState;
import com.amazonaws.services.paymentcryptography.model.transform.KeySummaryMarshaller;
import java.io.Serializable;

public class KeySummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String keyArn;
    private String keyState;
    private KeyAttributes keyAttributes;
    private String keyCheckValue;
    private Boolean exportable;
    private Boolean enabled;

    public void setKeyArn(String keyArn) {
        this.keyArn = keyArn;
    }

    public String getKeyArn() {
        return this.keyArn;
    }

    public KeySummary withKeyArn(String keyArn) {
        this.setKeyArn(keyArn);
        return this;
    }

    public void setKeyState(String keyState) {
        this.keyState = keyState;
    }

    public String getKeyState() {
        return this.keyState;
    }

    public KeySummary withKeyState(String keyState) {
        this.setKeyState(keyState);
        return this;
    }

    public KeySummary withKeyState(KeyState keyState) {
        this.keyState = keyState.toString();
        return this;
    }

    public void setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
    }

    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    public KeySummary withKeyAttributes(KeyAttributes keyAttributes) {
        this.setKeyAttributes(keyAttributes);
        return this;
    }

    public void setKeyCheckValue(String keyCheckValue) {
        this.keyCheckValue = keyCheckValue;
    }

    public String getKeyCheckValue() {
        return this.keyCheckValue;
    }

    public KeySummary withKeyCheckValue(String keyCheckValue) {
        this.setKeyCheckValue(keyCheckValue);
        return this;
    }

    public void setExportable(Boolean exportable) {
        this.exportable = exportable;
    }

    public Boolean getExportable() {
        return this.exportable;
    }

    public KeySummary withExportable(Boolean exportable) {
        this.setExportable(exportable);
        return this;
    }

    public Boolean isExportable() {
        return this.exportable;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public KeySummary withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyArn() != null) {
            sb.append("KeyArn: ").append(this.getKeyArn()).append(",");
        }
        if (this.getKeyState() != null) {
            sb.append("KeyState: ").append(this.getKeyState()).append(",");
        }
        if (this.getKeyAttributes() != null) {
            sb.append("KeyAttributes: ").append(this.getKeyAttributes()).append(",");
        }
        if (this.getKeyCheckValue() != null) {
            sb.append("KeyCheckValue: ").append(this.getKeyCheckValue()).append(",");
        }
        if (this.getExportable() != null) {
            sb.append("Exportable: ").append(this.getExportable()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeySummary)) {
            return false;
        }
        KeySummary other = (KeySummary)obj;
        if (other.getKeyArn() == null ^ this.getKeyArn() == null) {
            return false;
        }
        if (other.getKeyArn() != null && !other.getKeyArn().equals(this.getKeyArn())) {
            return false;
        }
        if (other.getKeyState() == null ^ this.getKeyState() == null) {
            return false;
        }
        if (other.getKeyState() != null && !other.getKeyState().equals(this.getKeyState())) {
            return false;
        }
        if (other.getKeyAttributes() == null ^ this.getKeyAttributes() == null) {
            return false;
        }
        if (other.getKeyAttributes() != null && !other.getKeyAttributes().equals(this.getKeyAttributes())) {
            return false;
        }
        if (other.getKeyCheckValue() == null ^ this.getKeyCheckValue() == null) {
            return false;
        }
        if (other.getKeyCheckValue() != null && !other.getKeyCheckValue().equals(this.getKeyCheckValue())) {
            return false;
        }
        if (other.getExportable() == null ^ this.getExportable() == null) {
            return false;
        }
        if (other.getExportable() != null && !other.getExportable().equals(this.getExportable())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        return other.getEnabled() == null || other.getEnabled().equals(this.getEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyArn() == null ? 0 : this.getKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.getKeyState() == null ? 0 : this.getKeyState().hashCode());
        hashCode = 31 * hashCode + (this.getKeyAttributes() == null ? 0 : this.getKeyAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getKeyCheckValue() == null ? 0 : this.getKeyCheckValue().hashCode());
        hashCode = 31 * hashCode + (this.getExportable() == null ? 0 : this.getExportable().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        return hashCode;
    }

    public KeySummary clone() {
        try {
            return (KeySummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeySummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

